﻿

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'CAFE_BOLUMLER') BEGIN
	CREATE TABLE CAFE_BOLUMLER (
		[CafeBolumId] INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
		[Bolum] [nvarchar](50) NOT NULL
	);
END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'CAFE_MASALAR') BEGIN
	CREATE TABLE CAFE_MASALAR (
		[CafeMasaId] INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
		[Fk_CafeBolumId] INT NOT NULL,
		[Masa] [nvarchar](50) NOT NULL,
		[Kapasite] INT NULL DEFAULT 4,
		[Passive] INT NULL DEFAULT 0,
		[x] INT NULL DEFAULT 0,
		[y] INT NULL DEFAULT 0,
	);
END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'CAFE_KURYELER') BEGIN
	CREATE TABLE CAFE_KURYELER (
		[CafeKuryeId] INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
		[IsimSoyad] [nvarchar](50) NOT NULL,
		[TCKN] [nvarchar](20) NOT NULL,
		[Tel] [nvarchar](20) NOT NULL,
		[Plaka] [nvarchar](20) NOT NULL,
		[Tel2] [nvarchar](20) NOT NULL,
		[Passive] INT NULL DEFAULT 0
	);
END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'CAFE_ENTEGRASYON') BEGIN
	CREATE TABLE CAFE_ENTEGRASYON (
		[CafeEntegrasyonId] INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
		[Tipi] [nvarchar](50) NOT NULL, -- yemeksepeti, getiryemek, trendyolyemek, 
		[Isim] [nvarchar](50) NULL DEFAULT '',
		[Url] [nvarchar](255) NULL DEFAULT '',
		[Username] [nvarchar](255) NULL DEFAULT '',
		[Password] [nvarchar](255) NULL DEFAULT '',
		[Passive] INT NULL DEFAULT 0
	);
END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'CAFE_ADISYON') BEGIN
	CREATE TABLE CAFE_ADISYON (
		[CafeAdisyonId] INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
		[Kanal] NVARCHAR(50) NOT NULL,  -- MASA, TELEFON, ENTEGRASYON
		[PlasiyerKodu] NVARCHAR(25) NOT NULL,
		[PosNo] INT NOT NULL,
		[Fk_CafeMasaId] INT NOT NULL,
		[Fk_CafeEntegrasyonId] INT NOT NULL,
		[Fk_CafeKuryeId] INT NOT NULL,
		[Iptal] INT NOT NULL,
		[Tarih] DATETIME NOT NULL,
		[Acilis] DATETIME NULL DEFAULT GETDATE(),
		[Kapanis] DATETIME NULL DEFAULT GETDATE(),
		[Durum] NVARCHAR(50) NOT NULL, -- ACCEPTED , REJECTED, PICKED_UP, CANCELLED , PREPARING
		[Islemde] INT NOT NULL,
		[IslemTarihi] DATETIME NULL DEFAULT GETDATE(),
		[AraToplam] FLOAT NOT NULL,
		[Iskonto1] FLOAT NOT NULL,
		[Iskonto2] FLOAT NOT NULL,
		[Iskonto3] FLOAT NOT NULL,
		[Iskonto4] FLOAT NOT NULL,
		[Iskonto5] FLOAT NOT NULL,
		[Iskonto6] FLOAT NOT NULL,
		[Vergi1] FLOAT NOT NULL,
		[Vergi2] FLOAT NOT NULL,
		[Vergi3] FLOAT NOT NULL,
		[Vergi4] FLOAT NOT NULL,
		[Vergi5] FLOAT NOT NULL,
		[Vergi6] FLOAT NOT NULL,
		[Vergi7] FLOAT NOT NULL,
		[Vergi8] FLOAT NOT NULL,
		[Vergi9] FLOAT NOT NULL,
		[Vergi10] FLOAT NOT NULL,
		[Meblag] FLOAT NOT NULL,
		[Musteri_IsimSoyad] NVARCHAR(100) NOT NULL,
		[Musteri_Tel] NVARCHAR(20) NOT NULL,
		[Musteri_VknTckn] NVARCHAR(11) NOT NULL,
		[Musteri_VergiDairesi] NVARCHAR(11) NOT NULL,
		[Musteri_Adres_Mahalle] NVARCHAR(255) NOT NULL,
		[Musteri_Adres_Sokak] NVARCHAR(255)  NOT NULL,
		[Musteri_Adres_BinaNo] NVARCHAR(50) NOT NULL,
		[Musteri_Adres_BinaSiteAdi] NVARCHAR(255) NOT NULL,
		[Musteri_Adres_Blok] NVARCHAR(50) NOT NULL,
		[Musteri_Adres_DaireNo] NVARCHAR(50) NOT NULL,
		[Musteri_Adres_Ilce] NVARCHAR(50) NOT NULL,
		[Musteri_Adres_Sehir] NVARCHAR(50)  NOT NULL,
		[Musteri_Latitude] FLOAT NULL,
		[Musteri_Longitude] FLOAT NULL,
		[BasimSayisi] INT NOT NULL,
		[Synced] INT NOT NULL,
	);
END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'CAFE_ADISYON_DETAY') BEGIN
	CREATE TABLE CAFE_ADISYON_DETAY (
		[CafeAdisyonDetayId] INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
		[Fk_CafeAdisyonId] INT NOT NULL,
		[Fk_StokId] INT NOT NULL,
		[SatirIptal] INT NOT NULL,
		[KoltukNo] INT NOT NULL,
		[Miktar] FLOAT NOT NULL,
		[OdenenMiktar] FLOAT NOT NULL,
		[BirimFiyat] FLOAT NOT NULL,
		[Tutar] FLOAT NOT NULL,
		[Iskonto1] FLOAT NOT NULL,
		[Iskonto2] FLOAT NOT NULL,
		[Iskonto3] FLOAT NOT NULL,
		[Iskonto4] FLOAT NOT NULL,
		[Iskonto5] FLOAT NOT NULL,
		[Iskonto6] FLOAT NOT NULL,
		[Fk_VergiId] INT NOT NULL,
		[Vergi] FLOAT NOT NULL,
		[Meblag] FLOAT NOT NULL,
		[Barkod] NVARCHAR(25) NOT NULL,
		[BarkodBirimi] INT NOT NULL,
		[BarkodFiyati] FLOAT NOT NULL,
		[BarkodKatsayisi] FLOAT NOT NULL,
		[BarkodMiktari] FLOAT NOT NULL,
		[CreatedAt] DATETIME NULL DEFAULT GETDATE(),
		[UpdatedAt] DATETIME NULL DEFAULT GETDATE(),
	);
END

GO
