﻿IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'ENT_YEMEKSEPETI_Product') BEGIN
	CREATE TABLE [dbo].[ENT_YEMEKSEPETI_Product](
		[id] [nvarchar](50) NOT NULL,
		[name] [nvarchar](max) NULL,
		[categoryName] [nvarchar](50) NULL,
		[paidPrice] [float] NULL,
		[quantity] [float] NULL,
		[remoteCode] [nvarchar](50) NULL,
		[unitPrice] [float] NULL,
		[comment] [nvarchar](max) NULL,
		[variationName] [nvarchar](50) NULL,
		[foodOrder_id] [nvarchar](255) NOT NULL,
		[discounts] [float] NULL,
		[discountsPlatform] [float] NULL,
		[discountsVendor] [float] NULL,
		[discountsThirdParty] [float] NULL,
		[toppings] [nvarchar](max) NULL,
	 CONSTRAINT [PK_ENT_YEMEKSEPETI_Product] PRIMARY KEY CLUSTERED 
	(
		[id] ASC,
		[foodOrder_id] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'ENT_YEMEKSEPETI_Foodorder') BEGIN
	CREATE TABLE [dbo].[ENT_YEMEKSEPETI_Foodorder](
		[token] [nvarchar](255) NOT NULL,
		[code] [nvarchar](50) NOT NULL,
		[createdAt] [datetime] NULL,
		[expeditionType] [nvarchar](50) NULL,
		[expiryDate] [date] NULL,
		[test] [bit] NULL,
		[shortCode] [nvarchar](256) NULL,
		[preOrder] [bit] NULL,
		[corporateTaxId] [nvarchar](512) NULL,
		[customerComment] [nvarchar](max) NULL,
		[email] [nvarchar](max) NULL,
		[firstName] [nvarchar](50) NULL,
		[lastName] [nvarchar](50) NULL,
		[mobilePhone] [nvarchar](50) NULL,
		[exceptedDeliveryTime] [date] NULL,
		[expressDelivery] [bit] NULL,
		[riderPickupTime] [nvarchar](50) NULL,
		[building] [nvarchar](50) NULL,
		[city] [nvarchar](50) NULL,
		[company] [nvarchar](50) NULL,
		[deliveryArea] [nvarchar](50) NULL,
		[deliveryInstructions] [nvarchar](50) NULL,
		[deliveryMainArea] [nvarchar](50) NULL,
		[entrance] [nvarchar](50) NULL,
		[flatnumber] [nvarchar](50) NULL,
		[floor] [nvarchar](50) NULL,
		[intercom] [nvarchar](50) NULL,
		[latitude] [float] NULL,
		[longitude] [float] NULL,
		[number] [nvarchar](50) NULL,
		[postcode] [nvarchar](50) NULL,
		[streed] [nvarchar](50) NULL,
		[countryCode] [nvarchar](50) NULL,
		[currencySymbol] [nvarchar](50) NULL,
		[platform] [nvarchar](50) NULL,
		[platformKey] [nvarchar](50) NULL,
		[paymentStatus] [nvarchar](50) NULL,
		[paymentType] [nvarchar](50) NULL,
		[pickupTime] [nvarchar](50) NULL,
		[pickupCode] [nvarchar](50) NULL,
		[restaurantId] [nvarchar](50) NULL,
		[grandTotal] [float] NULL,
		[payRestaurant] [float] NULL,
		[riderTip] [float] NULL,
		[totalNet] [float] NULL,
		[vatTotal] [float] NULL,
		[collectFromCustomer] [nvarchar](50) NULL,
		[orderAcceptedUrl] [nvarchar](50) NULL,
		[orderRejectedUrl] [nvarchar](50) NULL,
		[orderPickedUpUrl] [nvarchar](50) NULL,
		[orderPreparedUrl] [nvarchar](50) NULL,
		[localStatus] [bit] NULL,
		[status] [nvarchar](50) NULL,
		[SERVERSTATUS] [int] NULL,
		[discounts] [float] NULL,
		[discountsPlatform] [float] NULL,
		[discountsVendor] [float] NULL,
		[discountsThirdParty] [float] NULL,
		[deliveryFees] [nvarchar](max) NULL,
	 CONSTRAINT [PK_ENT_YEMEKSEPETI_Foodorder] PRIMARY KEY CLUSTERED 
	(
		[token] ASC,
		[code] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'ENT_TRENDYOL_Item') BEGIN
	CREATE TABLE [dbo].[ENT_TRENDYOL_Item](
		[lineItemId] [int] NOT NULL,
		[Line_id] [uniqueidentifier] NOT NULL,
		[packageItemId] [nvarchar](50) NULL,
		[isCancelled] [bit] NULL,
		[promotions] [nvarchar](max) NULL,
	 CONSTRAINT [PK_ENT_TRENDYOL_Item] PRIMARY KEY CLUSTERED 
	(
		[lineItemId] ASC,
		[Line_id] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'ENT_TRENDYOL_Foodorder') BEGIN
	CREATE TABLE [dbo].[ENT_TRENDYOL_Foodorder](
		[id] [nvarchar](64) NOT NULL,
		[supplierId] [int] NULL,
		[storeId] [int] NULL,
		[orderCode] [nvarchar](50) NULL,
		[deliveryType] [nvarchar](50) NULL,
		[packageCreationDate] [datetime] NULL,
		[packageModificationDate] [datetime] NULL,
		[preparationTime] [int] NULL,
		[orderId] [varchar](50) NULL,
		[orderNumber] [nvarchar](50) NULL,
		[totalPrice] [float] NULL,
		[callCenterPhone] [nvarchar](50) NULL,
		[customerId] [int] NULL,
		[customerFirstName] [nvarchar](max) NULL,
		[customerLastName] [nvarchar](max) NULL,
		[customerEmail] [nvarchar](max) NULL,
		[paymentType] [nvarchar](50) NULL,
		[paymentMealcardSourceType] [nvarchar](50) NULL,
		[paymentOndelivery] [nvarchar](50) NULL,
		[addressFirstName] [nvarchar](max) NULL,
		[addressLastName] [nvarchar](max) NULL,
		[addressCompany] [nvarchar](max) NULL,
		[address] [nvarchar](max) NULL,
		[addressCity] [nvarchar](100) NULL,
		[addressDistrict] [nvarchar](100) NULL,
		[addressNeighborhood] [nvarchar](100) NULL,
		[addressApertmentNumber] [nvarchar](100) NULL,
		[addressFloor] [nvarchar](100) NULL,
		[addressDoorNumber] [nvarchar](100) NULL,
		[addressDescription] [nvarchar](max) NULL,
		[addressLatitude] [nvarchar](50) NULL,
		[addressLongitude] [nvarchar](50) NULL,
		[phone] [nvarchar](100) NULL,
		[packageStatus] [nvarchar](50) NULL,
		[customerNote] [nvarchar](max) NULL,
		[lastModifiedDate] [datetime] NULL,
		[isCourierNearby] [bit] NULL,
		[cancelInfoReasonCode] [int] NULL,
		[eta] [nvarchar](50) NULL,
		[pickupEtaState] [nvarchar](100) NULL,
		[localstatus] [bit] NULL,
		[SERVERSTATUS] [int] NULL,
		[storePickupSelected] [bit] NULL,
	 CONSTRAINT [PK_ENT_TRENDYOL_Foodorder] PRIMARY KEY CLUSTERED 
	(
		[id] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'ENT_TRENDYOL_Line') BEGIN
	CREATE TABLE [dbo].[ENT_TRENDYOL_Line](
		[id] [uniqueidentifier] NOT NULL,
		[price] [float] NULL,
		[unitSellingPrice] [float] NULL,
		[productId] [int] NULL,
		[name] [nvarchar](max) NULL,
		[isClaimRateExceeded] [bit] NULL,
		[Foodorder_id] [nvarchar](64) NULL,
		[modifierProducts] [nvarchar](max) NULL,
		[items] [nvarchar](max) NULL,
		[packageItemIds] [nvarchar](max) NULL,
	 CONSTRAINT [PK_TRENDYOL_Line] PRIMARY KEY CLUSTERED 
	(
		[id] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

END

GO


IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'ENT_MIGROSYEMEK_Item') BEGIN
	CREATE TABLE [dbo].[ENT_MIGROSYEMEK_Item](
		[id] [bigint] NOT NULL,
		[productId] [bigint] NOT NULL,
		[name] [nvarchar](50) NULL,
		[price] [float] NULL,
		[priceText] [nvarchar](50) NULL,
		[amount] [float] NULL,
		[note] [nvarchar](max) NULL,
		[foodOrder_id] [int] NOT NULL,
	 CONSTRAINT [PK_MIGROSYEMEK_Item] PRIMARY KEY CLUSTERED 
	(
		[id] ASC,
		[productId] ASC,
		[foodOrder_id] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'ENT_MIGROSYEMEK_Option') BEGIN
	CREATE TABLE [dbo].[ENT_MIGROSYEMEK_Option](
		[optionHeaderId] [int] NOT NULL,
		[objectOptionItemId] [int] NULL,
		[optionItemId] [int] NULL,
		[productId] [bigint] NULL,
		[parentObjectOptionItemId] [int] NULL,
		[headerName] [nvarchar](50) NULL,
		[itemNames] [nvarchar](50) NULL,
		[primaryDiscountedPrice] [float] NULL,
		[primaryDiscountedPriceText] [nvarchar](50) NULL,
		[primaryPrice] [float] NULL,
		[primaryPriceText] [nvarchar](50) NULL,
		[quantity] [int] NULL,
		[excluded] [bit] NULL,
		[objectOptionHeaderPriority] [int] NULL,
		[objectOptionItemPriority] [int] NULL,
		[optionType] [nvarchar](50) NULL,
		[foodOrder_id] [int] NOT NULL,
		[item_id] [bigint] NOT NULL,
	 CONSTRAINT [PK_MIGROSYEMEK_Option] PRIMARY KEY CLUSTERED 
	(
		[optionHeaderId] ASC,
		[foodOrder_id] ASC,
		[item_id] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY];

END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'ENT_MIGROSYEMEK_Foodorder') BEGIN
	CREATE TABLE [dbo].[ENT_MIGROSYEMEK_Foodorder](
		[id] [bigint] NOT NULL,
		[description] [nvarchar](50) NULL,
		[status] [nvarchar](50) NULL,
		[deliveryProvider] [nvarchar](50) NULL,
		[storeId] [bigint] NULL,
		[storeName] [nvarchar](50) NULL,
		[groupId] [bigint] NULL,
		[groupName] [nvarchar](50) NULL,
		[customerId] [bigint] NULL,
		[firstName] [nvarchar](50) NULL,
		[lastName] [nvarchar](50) NULL,
		[fullName] [nvarchar](50) NULL,
		[phoneNumber] [nvarchar](50) NULL,
		[deliveryAddressId] [bigint] NULL,
		[direction] [nvarchar](50) NULL,
		[detail] [nvarchar](max) NULL,
		[cityId] [bigint] NULL,
		[cityName] [nvarchar](50) NULL,
		[townId] [bigint] NULL,
		[townName] [nvarchar](50) NULL,
		[districtId] [bigint] NULL,
		[districtName] [nvarchar](50) NULL,
		[latitude] [float] NULL,
		[longitude] [float] NULL,
		[totalAmountAsPenny] [float] NULL,
		[totalText] [nvarchar](50) NULL,
		[discountedAmountAsPenny] [float] NULL,
		[discountedText] [nvarchar](50) NULL,
		[restaurantDiscountedAmountAsPenny] [float] NULL,
		[restaurantDiscountedText] [nvarchar](50) NULL,
		[migrosDiscountedAmountAsPenny] [float] NULL,
		[migrosDiscountedText] [nvarchar](50) NULL,
		[paymentHashedNameId] [int] NULL,
		[paymentName] [nvarchar](50) NULL,
		[paymentDescription] [nvarchar](50) NULL,
		[paymentIsOnlinePayment] [bit] NULL,
		[paymentSimplifiedName] [nvarchar](50) NULL,
		[paymentSimplifiedHashedNameId] [nvarchar](50) NULL,
		[orderNote] [nvarchar](max) NULL,
		[saveGreen] [bit] NULL,
		[contactlessDelivery] [bit] NULL,
		[ringDoorBell] [bit] NULL,
		[createdAsMs] [datetime] NULL,
		[localStatus] [bit] NULL,
		[SERVERSTATUS] [int] NULL,
	 CONSTRAINT [PK_MIGROSYEMEK_Foodorder] PRIMARY KEY CLUSTERED 
	(
		[id] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

END

GO


IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'ENT_GETIR_Product') BEGIN
	CREATE TABLE [dbo].[ENT_GETIR_Product](
		[id] [nvarchar](50) NOT NULL,
		[imageURL] [nvarchar](max) NULL,
		[wideImageURL] [nvarchar](max) NULL,
		[count] [float] NULL,
		[product] [nvarchar](50) NULL,
		[name] [nvarchar](max) NULL,
		[price] [float] NULL,
		[optionPrice] [float] NULL,
		[priceWithOption] [float] NULL,
		[totalPrice] [float] NULL,
		[totalOptionPrice] [float] NULL,
		[totalPriceWithOption] [float] NULL,
		[note] [nvarchar](max) NULL,
		[discountedPriceWithOption] [float] NULL,
		[totalDiscountedPriceWithOption] [float] NULL,
		[displayInfoTitle] [nvarchar](max) NULL,
		[displayInfoOptions] [nvarchar](max) NULL,
		[Foodorder_id] [nvarchar](50) NULL,
	 CONSTRAINT [PK_GETIR_Product] PRIMARY KEY CLUSTERED 
	(
		[id] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

END

GO


IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'ENT_GETIR_Optioncategory') BEGIN
	CREATE TABLE [dbo].[ENT_GETIR_Optioncategory](
		[optionCategory] [nvarchar](50) NOT NULL,
		[Foodorder_id] [nvarchar](50) NOT NULL,
		[Product_id] [nvarchar](50) NOT NULL,
		[name] [nvarchar](max) NULL,
	 CONSTRAINT [PK_GETIR_Optioncategory] PRIMARY KEY CLUSTERED 
	(
		[optionCategory] ASC,
		[Foodorder_id] ASC,
		[Product_id] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

END

GO


IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'ENT_GETIR_Option') BEGIN
	CREATE TABLE [dbo].[ENT_GETIR_Option](
		[option] [nvarchar](50) NOT NULL,
		[Optioncategory_id] [nvarchar](50) NOT NULL,
		[Foodorder_id] [nvarchar](50) NOT NULL,
		[Product_id] [nchar](10) NOT NULL,
		[product] [nvarchar](50) NULL,
		[name] [nvarchar](max) NULL,
		[price] [float] NULL,
	 CONSTRAINT [PK_GETIR_Option] PRIMARY KEY CLUSTERED 
	(
		[option] ASC,
		[Optioncategory_id] ASC,
		[Foodorder_id] ASC,
		[Product_id] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'ENT_GETIR_Foodorder') BEGIN
	CREATE TABLE [dbo].[ENT_GETIR_Foodorder](
		[id] [nvarchar](50) NOT NULL,
		[status] [int] NULL,
		[isScheduled] [bit] NULL,
		[confirmationId] [nvarchar](50) NULL,
		[clientNote] [nvarchar](max) NULL,
		[doNotKnock] [bit] NULL,
		[dropOffAtDoor] [bit] NULL,
		[totalPrice] [decimal](14, 2) NULL,
		[totalDiscountedPrice] [decimal](14, 2) NULL,
		[checkoutDate] [datetime] NULL,
		[deliveryType] [int] NULL,
		[isEcoFriendly] [bit] NULL,
		[paymentMethod] [int] NULL,
		[paymentMethodText] [nvarchar](50) NULL,
		[isQueued] [bit] NULL,
		[clientname] [nvarchar](max) NULL,
		[contactPhoneNumber] [nvarchar](50) NULL,
		[clientPhoneNumber] [nvarchar](50) NULL,
		[address] [nvarchar](max) NULL,
		[aptNo] [nvarchar](50) NULL,
		[floor] [nvarchar](50) NULL,
		[doorNo] [nvarchar](50) NULL,
		[city] [nvarchar](50) NULL,
		[district] [nvarchar](50) NULL,
		[addressDescription] [nvarchar](max) NULL,
		[courierName] [nvarchar](max) NULL,
		[courierStatus] [int] NULL,
		[cancelDate] [datetime] NULL,
		[cancelNote] [nvarchar](max) NULL,
		[cancelReason] [nvarchar](max) NULL,
		[cancelSource] [int] NULL,
		[localStatus] [bit] NULL,
		[addressLatitude] [nvarchar](50) NULL,
		[addressLongitude] [nvarchar](50) NULL,
		[SERVERSTATUS] [int] NULL,
	 CONSTRAINT [PK_GETIR_Foodorder] PRIMARY KEY CLUSTERED 
	(
		[id] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

END

GO
