﻿
IF  EXISTS (SELECT * FROM sys.objects WHERE name=N'fnOnlyNumber' AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION dbo.fnOnlyNumber
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE FUNCTION dbo.fnOnlyNumber ( @strAlphaNumeric nVARCHAR(50) )  
RETURNS nVARCHAR(50)  AS  
 BEGIN
 DECLARE @intAlpha INT
 SET @intAlpha = PATINDEX('%^0-9%', @strAlphaNumeric)
 BEGIN
 WHILE @intAlpha > 0
 BEGIN
 SET @strAlphaNumeric = STUFF(@strAlphaNumeric, @intAlpha, 1, '' )
 SET @intAlpha = PATINDEX('%^0-9%', @strAlphaNumeric )
 END
 END
 RETURN ISNULL(@strAlphaNumeric,0)
 END


GO



IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'dbo.fnYaziTura') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION dbo.fnYaziTura
GO

CREATE FUNCTION dbo.fnYaziTura(@num AS numeric(18,2), @isMoney as bit,@ParaBirim NVARCHAR(20),@KucukBirim NVARCHAR(20))
	RETURNS NVARCHAR(255)
AS
BEGIN
	DECLARE @Split tinyint
	DECLARE @iSplit tinyint
	DECLARE @sNum NVARCHAR(20)
	DECLARE @NumSet NVARCHAR(3)
	DECLARE @Char char(1)
	DECLARE @NumText NVARCHAR(255)
	DECLARE @SetText NVARCHAR(100)
	DECLARE @HunText NVARCHAR(100)
	DECLARE @CharText NVARCHAR(50)
	DECLARE @Match bit
	DECLARE @Point tinyint
	DECLARE @Cents NVARCHAR(2)
	DECLARE @CentText NVARCHAR(100)
	DECLARE @NumStrings TABLE (Num int, NumStr NVARCHAR(20))
	INSERT INTO @NumStrings
	SELECT 1, 'Bir'
	UNION SELECT 2, 'İki'
	UNION SELECT 3, 'Üç'
	UNION SELECT 4, 'Dört'
	UNION SELECT 5, 'Beş'
	UNION SELECT 6, 'Altı'
	UNION SELECT 7, 'Yedi'
	UNION SELECT 8, 'Sekiz'
	UNION SELECT 9, 'Dokuz'
	UNION SELECT 10, 'On'
	UNION SELECT 11, 'Onbir'
	UNION SELECT 12, 'Oniki'
	UNION SELECT 13, 'Onüç'
	UNION SELECT 14, 'Ondört'
	UNION SELECT 15, 'Onbeş'
	UNION SELECT 16, 'Onaltı'
	UNION SELECT 17, 'Onyedi'
	UNION SELECT 18, 'Onsekiz'
	UNION SELECT 19, 'Ondokuz'
	UNION SELECT 20, 'Yirmi'
	UNION SELECT 30, 'Otuz'
	UNION SELECT 40, 'Kırk'
	UNION SELECT 50, 'Elli'
	UNION SELECT 60, 'Altmış'
	UNION SELECT 70, 'Yetmiş'
	UNION SELECT 80, 'Seksen'
	UNION SELECT 90, 'Doksan'
	SET @sNum = cast(@num as NVARCHAR(20))
	--convert any cent text first, then the
	-- whole number
	SET @Point = charindex('.', @sNum)
	IF @Point > 0
	BEGIN
	SET @Cents = substring(@sNum, @Point + 1, 2)
	SET @sNum = left(@sNum, @Point-1)
	--if isMoney THEN combine the two digits (eg 11 = eleven)
	IF @isMoney = 1
	BEGIN --look FOR matches WITH the RIGHT İki characters
	SET @Match = (select count(*) FROM @NumStrings WHERE Num = @Cents)
	IF @Match <> 0
	BEGIN
	SET @CentText = (select NumStr FROM @NumStrings WHERE Num = @Cents)
	END
	ELSE
	BEGIN
	SET @CentText = isnull((select NumStr FROM @NumStrings WHERE Num = left(@Cents, 1) + '0'),'') + (select NumStr from @NumStrings where Num = right(@Cents, 1))
	END
	END
	ELSE --if NOT isMBiry THEN treat each digit seperately (eg 11 = Bir Bir)
	BEGIN
	SET @CentText = isnull((select NumStr FROM @NumStrings WHERE Num = left(@Cents, 1)),'') + isnull((select NumStr from @NumStrings where Num = right(@Cents, 1)),'')
	END
	END
	IF @CentText IS NULL
	SET @CentText = ''
	--break the number into blocks of 3 characters
	SET @Split = ((len(@sNum)-1) / 3) + 1
	SET @iSplit = 0
	SET @NumText = ''
	WHILE @iSplit < @Split
	BEGIN
	SET @CharText = ''
	SET @HunText = ''
	SET @SetText = ''
	SET @NumSet = right(left(@sNum, len(@sNum) - @iSplit * 3), 3)
	IF len(@Numset) = 3 --Calculate ANY hundreds
	BEGIN
	SET @Char = left(@NumSet, 1)
	if @Char='1' 
	SET @HunText = 'Yüz'
	ELSE
	SET @HunText = isnull((select NumStr FROM @NumStrings WHERE Num = @Char) + 'Yüz', '')
	SET @SetText = @HunText
	END
	--look FOR matches WITH the RIGHT two characters
	SET @Match = (select count(*) FROM @NumStrings WHERE Num = right(@NumSet, 2))
	IF @Match <> 0
	BEGIN
	SET @CharText = (select NumStr FROM @NumStrings WHERE Num = right(@NumSet, 2))
	END
	ELSE
	BEGIN
	SET @CharText = isnull((select NumStr FROM @NumStrings WHERE Num = left(right(@NumSet, 2), 1) + '0'),'') + (select NumStr from @NumStrings where Num = right(@NumSet, 1))
	END
	--make sure there IS something in @CharText AND @SetText (ie IF @NumSet = x00, x000)
	IF @CharText IS NULL SET @CharText = ''
	IF @SetText IS NULL set @SetText = ''
	--seperate ANY hundreds FROM Ons/units WITH an 'and'
	IF @HunText <> '' AND @CharText <> ''
	SET @SetText = @SetText + ''
	--if there are no hundreds, it's the smallest SET AND there are other sets, ADD an 'and' before
	IF @HunText = '' AND @CharText <> '' and @iSplit = 0 and @Split > 1 and @CentText = ''
	SET @SetText = '' + @SetText
	SET @SetText = @SetText + @CharText
	--append the SET suffix text. ADD a ',' AS long as there IS something in the lowest set
	if @iSplit = 1 AND @SetText='Bir' BEGIN 
		SET @SetText=''
		SET @SetText = @SetText + CASE @iSplit
			WHEN 0 THEN ''
			WHEN 1 THEN 'Bin'
			WHEN 2 THEN 'Milyon'
			WHEN 3 THEN 'Milyar'
			WHEN 4 THEN 'Trilyon'
			WHEN 5 THEN 'Katrilyon'
		END + CASE WHEN len(@NumText) > 0 THEN '' ELSE '' end
	END ELSE BEGIN
		IF @SetText <> ''
		SET @SetText = @SetText + CASE @iSplit
		WHEN 0 THEN ''
		WHEN 1 THEN 'Bin'
		WHEN 2 THEN 'Milyon'
		WHEN 3 THEN 'Milyar'
		WHEN 4 THEN 'Trilyon'
		WHEN 5 THEN 'Katrilyon'
		END + CASE WHEN len(@NumText) > 0 THEN '' ELSE '' end
		END
		SET @NumText = @SetText + @NumText
		SET @iSplit = @iSplit + 1
	END
	--add any dollars and cent text
	IF @isMoney = 1 AND @NumText <> '' and rtrim(ltrim(@NumText)) <> 'Bir'
		SET @NumText = @NumText + ' ' + @ParaBirim
	IF @isMoney = 1 AND rtrim(ltrim(@NumText)) = 'Bir'
		SET @NumText = @NumText + ' ' + @ParaBirim
	IF @isMoney = 1 AND @CentText <> '' and rtrim(ltrim(@CentText)) <> 'Bir'
		SET @CentText = @CentText + ' ' + @KucukBirim
	IF @isMoney = 1 AND rtrim(ltrim(@CentText)) = 'Bir'
		SET @CentText = @CentText + ' ' + @KucukBirim
	IF @isMoney = 0 AND @CentText <> ''
		SET @CentText = ' Point' + @CentText
	IF @isMoney = 1 AND @NumText <> '' and @CentText <> ''
		SET @CentText = ' ' + @CentText
	--combine dollars and cents
	SET @NumText = @NumText + @CentText
	--add 'Minus' for negative numbers
	IF left(@sNum, 1) = '-'
		SET @NumText = 'virgül' + @NumText

	RETURN @NumText
END


GO




IF  NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'dbo.PRINT_DESIGNS') AND type in (N'U')) BEGIN
	CREATE TABLE dbo.PRINT_DESIGNS (
		PrintDesignId INT IDENTITY(1,1) PRIMARY KEY  ,
		FormCode NVARCHAR(30) NULL DEFAULT ''  ,
		ReportName NVARCHAR(100) NULL DEFAULT ''  , 
		ReportData IMAGE NULL  , 
		ReportSQL IMAGE NULL  ,
		bDefault INT NULL DEFAULT 0  , 
		ReportType INT NULL DEFAULT 0 
	);
END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'AYAR_GRUPLARI') BEGIN
	CREATE TABLE AYAR_GRUPLARI (
		AyarGrupID INT NOT NULL PRIMARY KEY,
		Aciklama nvarchar (50) NOT NULL
	);
	
	INSERT INTO AYAR_GRUPLARI(AyarGrupID,Aciklama) VALUES (1, 'BAĞLANTI AYARLARI');
	INSERT INTO AYAR_GRUPLARI(AyarGrupID,Aciklama) VALUES (2, 'GENEL AYARLAR');
	INSERT INTO AYAR_GRUPLARI(AyarGrupID,Aciklama) VALUES (3, 'EVRAK AYARLARI');
	INSERT INTO AYAR_GRUPLARI(AyarGrupID,Aciklama) VALUES (4, 'İSKONTO AYARLARI');
	INSERT INTO AYAR_GRUPLARI(AyarGrupID,Aciklama) VALUES (5, 'GÜVENLİK AYARLARI');
	INSERT INTO AYAR_GRUPLARI(AyarGrupID,Aciklama) VALUES (6, 'ÖKC ENTEGRASYON AYARLARI');
	INSERT INTO AYAR_GRUPLARI(AyarGrupID,Aciklama) VALUES (7, 'TICKET ENTEGRASYON AYARLARI');
	INSERT INTO AYAR_GRUPLARI(AyarGrupID,Aciklama) VALUES (8, 'HIZLI SEÇİM PANEL AYARLARI');
	INSERT INTO AYAR_GRUPLARI(AyarGrupID,Aciklama) VALUES (9, 'FİŞ AYARLARI');
	INSERT INTO AYAR_GRUPLARI(AyarGrupID,Aciklama) VALUES (10, 'ÇEKMECE AYARLARI');
	INSERT INTO AYAR_GRUPLARI(AyarGrupID,Aciklama) VALUES (11, 'MÜŞTERİ EKRAN AYARLARI');
	INSERT INTO AYAR_GRUPLARI(AyarGrupID,Aciklama) VALUES (12, 'TERAZİ AYARLARI');
	INSERT INTO AYAR_GRUPLARI(AyarGrupID,Aciklama) VALUES (13, 'PUAN AYARLARI');
	INSERT INTO AYAR_GRUPLARI(AyarGrupID,Aciklama) VALUES (14, 'ADISYON AYARLARI');

END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'AYARLAR') BEGIN
	CREATE TABLE AYARLAR (
		AyarID INT NOT NULL PRIMARY KEY,
		Fk_AyarGrubu INT NOT NULL,
		Aciklama nvarchar (100) NOT NULL,
		Deger nvarchar (255) NOT NULL,
		VeriTipi INT NOT NULL
	);
	
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (1, 2, 'Şirket İsmi', 'DINAMIKUP ALITEKNOLOJI',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (2, 1, 'Web Servis URL', 'http://localhost:1649/Service.asmx',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (3, 1, 'Web Servis Parola', 'f7jaIV39S1',4);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (4, 1, 'Veri Gönderim Periyodu (saniye)', '30',1);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (5, 1, 'Veri Alım Periyodu (saniye)', '60',1);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (6, 2, 'Depo No', '1',1);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (7, 4, 'Satır İskonto Yüzdesi (Maksimum)', '50',2);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (8, 4, 'Belge İskonto Yüzdesi (Maksimum)', '50',2);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (9, 2, 'Şubeye Ait Kasa Kodu', '100',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (10, 4, 'Reyon İndirimi Uygulansın', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (11, 2, 'Girişte Plasiyer Seçimi Aktif', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (12, 5, 'Yönetici Şifresi (Boşsa Pasif)', '',4);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (13, 3, 'Cari Risk Limiti ve Kilitleme Aktif', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (14, 3, 'Barkod Fiyatı Aktif (2.Birim: 12.SF, 3.Birim:13.SF)', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (15, 4, 'Cari Otomatik İskonto Yüzdesi Aktif', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (16, 2, 'Şube No', '1',1);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (17, 3, 'Muhtelif Cari Kodu (Boşsa Pasif)', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (18, 3, 'Peşin Müşteri Kodu', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (19, 3, 'Satır Birleştirme (0: Devre Dışı, 1: Ekleme Sırasında, 2: Belge Kayıt Sırasında)', '0',5);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (20, 3, 'Birim Fiyat Değiştirilebilsin', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (21, 3, 'Stok Eksiye Düşme Kontrolü (0: Devre Dışı, 1: Uyar, 2: Kabul Etme)', '0',5);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (22, 3, 'Ödeme Tipi Tıklanınca Evrak Kaydedilsin', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (23, 2, 'Simge Durumunda Küçültme', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (24, 2, 'Excel Aktarım Menüsü', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (25, 3, '14 Haneli Barkod Okuma Modu (0: Normal, 1: İlk Karakter Yok, 2: Son Karakter Yok)', '0',5);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (26, 3, '0 Fiyatlı Ürün Satılabilsin (0: Hayır, 1: Evet)', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (27, 3, 'Cari Seçiminde Açık Hesap Dışı İşlem Yapılamaz.', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (28, 4, 'Cari-Stok İskonto Tanımı Uygulansın.', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (29, 4, 'Görünen İskonto Sayısı (Maksimum: 6)', '2',1);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (30, 4, 'İskontolu Fiyat Görülsün (0: Hayır, 1: Evet)', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (31, 0, 'DB Versiyon', '1.7.5.1',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (32, 2, 'Program Modu (0: Türkiye, 1: Kıbrıs, 2: Ticket)', '0',5);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (33, 2, 'Satış Ekran Modu (0: Normal, 1: Liste)', '0',5);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (34, 7, 'RedID', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (35, 7, 'Pass', '',4);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (36, 7, 'Vergi Kimlik No', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (37, 7, 'Üye Adresi', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (38, 7, 'Ticket Servis URL', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (39, 2, 'Kur Hesaplama Şekli (0: Döviz Alış, 1: Döviz Satış, 2: Efektif Alış, 3: Efektif Satış)', '3',5);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (40, 2, 'Tema', 'DevExpress Style',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (41, 2, 'Kasa No', '1',1);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (42, 2, 'Provider', 'SQLNCLI10',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (43, 2, 'Vade Gun Sayisi', '30',1);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (44, 2, 'Satis Fiyati Liste No', '1',1);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (45, 2, 'Tahsilat Aktif', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (46, 2, 'Tahsilat Seri', 'THS',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (47, 2, 'Bildirim Sesleri', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (48, 0, 'Son Belge No', '0',1);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (49, 8, 'Aktif', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (50, 8, 'Tus1Kod', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (51, 8, 'Tus2Kod', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (52, 8, 'Tus3Kod', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (53, 8, 'Tus4Kod', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (54, 8, 'Tus5Kod', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (55, 8, 'Tus6Kod', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (56, 8, 'Tus7Kod', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (57, 8, 'Tus8Kod', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (58, 8, 'Tus9Kod', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (59, 9, 'Fiş Tipi', '0',5);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (60, 9, 'İade Fis Basimi', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (61, 9, 'Yazici İsmi', 'A10M MiniPrinter',6);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (62, 9, 'Max Stok Satir Sayısı', '1000',1);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (63, 9, 'Bilgi Fisi Tasarımı', '2',1);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (64, 9, 'Miktar Formati', '0.00',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (65, 9, 'Bilgi Fisi Vergi Detayi', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (66, 9, 'Odemeler Gosterilsin', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (67, 9, 'Cari Unvani Gosterilsin', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (68, 9, 'Cari Adresi Gosterilsin', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (69, 9, 'Cari Bakiye Gosterilsin', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (70, 9, 'Cari Kalan Limit Gosterilsin', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (71, 9, 'Ust Bilgi1', 'ÖĞRETMEN BİLGE YOLU KIRTASİYE',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (72, 9, 'Ust Bilgi2', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (73, 9, 'Ust Bilgi3', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (74, 9, 'Ust Bilgi4', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (75, 9, 'Alt Bilgi1', 'BİZİ TERCİH ETTİĞİNİZ İÇİN',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (76, 9, 'Alt Bilgi2', 'TEŞEKKÜR EDERİZ',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (77, 9, 'Alt Bilgi3', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (78, 9, 'Alt Bilgi4', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (79, 9, 'Alt Bosluk', '40',1);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (80, 9, 'Kopya Sayisi', '1',1);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (81, 9, 'Cari Secimi Kopya Sayisi', '1',1);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (82, 9, 'Gun Sonu Vergi Detayi', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (83, 9, 'Gun Sonu Fatura Detayi', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (84, 9, 'Gun Sonu Tahsilat Detayi', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (85, 9, 'Gun Sonu Tahsilat Ozeti', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (86, 9, 'Gun Sonu Yazici Ismi', 'A10M MiniPrinter',6);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (87, 9, 'Tahsilat Yazici Ismi', 'A10M MiniPrinter',6);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (88, 10, 'Aktif', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (89, 10, 'Tip', '0',5);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (90, 10, 'Port', 'COM1',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (91, 10, 'Uygulama Yolu', 'D:\APPOSTAR CEKMECE\DK1.exe',7);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (92, 11, 'Aktif', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (93, 11, 'Tip', '1',5);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (94, 11, 'Port', 'COM2',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (95, 11, 'Müşteri Ekranı Başlangıç Konumu', '1366,768',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (96, 12, 'Aktif', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (97, 12, 'Terazi Tipi', '2',5);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (98, 12, 'Terazi Seri Port Adı', 'COM1',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (99, 12, 'BaudRate', '9600',1);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (100, 12, 'DataBits', '8',1);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (101, 12, 'Parity', 'None',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (102, 12, 'StopBits', 'One',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (103, 6, 'Pos Entegrasyon Aktif', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (104, 6, 'ÖKC Cihaz Marka', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (105, 6, 'ÖKC Cihaz Model', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (106, 6, 'Cihaz Seri No', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (107, 6, 'ECR Seri No', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (108, 0, 'Urun Arama Tipi (0: Barkod, 1: Stok Kodu, 2: Stok İsmi)', '0',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (109, 0, 'F12 Arama Tipi (0: Barkod, 1: Stok Kodu, 2: Stok İsmi)', '0',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (110, 0, 'ChangeLog Versiyon', '1.7.5.1',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (111, 0, 'Config Dosyasından Ayarlar Alındı', '1',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (112, 0, 'Toptan / Perakende', '1',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (113, 12, 'Terazi IP Adresi', '127.0.0.1',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (114, 12, 'Terazi Portu', '9090',1);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (115, 12, 'Terazi Uygulama Yolu', 'C:\SW1100\ScaleConnector\ScaleConnector.exe',7);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (116, 8, 'Satış Ekranında Ürün Resimleri Görüntülensin', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (117, 11, 'Reklam Resimleri Klasörü', '',8);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (118, 11, 'Gösterim Süresi (saniye)', '0',1);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (119, 3, 'Fiyat Listesinde Gösterilmeyecek Birim', '0',5);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (120, 3, 'Ürün Seçimi Yapılabilsin', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (121, 3, 'Belge İptali Yapılabilsin', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (122, 3, 'Satır İptali Yapılabilsin', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (123, 3, 'İade Alımı Yapılabilsin', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (124, 3, 'Barkod içeriği kod+miktar değilse ondalıklı girişte uyarı ver', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (125, 0, 'Cari Hesap Arama Tipi (0: Cari Kodu, 1: Ünvan, 2: Cep Telefonu)', '1',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (126, 3, 'Cari Hesap Yoksa Yeni Kayıt Yapılabilsin', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (127, 5, 'Belge İptali Şifresi (Boşsa Pasif)', '',4);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (128, 5, 'Satır İptali Şifresi (Boşsa Pasif)', '',4);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (129, 5, 'İade Alım Şifresi (Boşsa Pasif)', '',4);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (130, 5, 'Program Kapatma Şifresi (Boşsa Pasif)', '',4);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (131, 3, 'Evrak Detayı Satır Sayısı Göster', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (132, 11, 'Müşteri Ekranında Her Zaman Liste Göster', '',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (133, 4, 'Çoklu İskonto Girişi Yapılabilsin', '',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (134, 2, 'Mobil Raporlara Veri Gönderilsin', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (135, 0, 'Satışlar İrsaliye Kaydedilsin', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (136, 3, 'Döviz Seçimi Yapılabilsin', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (137, 9, 'Gun Sonu Stok Detayi', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (138, 8, 'PLU Penceresi Gösterim Şekli', '0',5);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (139, 3, 'Son Giriş Maliyeti Gösterilsin', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (140, 3, 'Depodaki Miktar Gösterilsin', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (141, 2, 'Akıllı Arama Aktif', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (142, 3, 'Genius Kart Girişi Aktif', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (143, 3, 'Genius Kart Perakende Cari Kodu', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (144, 3, 'Vergi Ayırma Aktif', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (145, 3, 'Ürün Listesinde Sıra No Göster', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (146, 2, 'Tediye Aktif', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (147, 2, 'Tediye Seri', 'TDY',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (148, 2, 'Kasa Giriş-Çıkış Fişi Aktif', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (149, 9, 'Gun Sonu Giriş-Çıkış Detayi', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (150, 2, 'Satışta Plasiyer Seçimi Aktif', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (151, 2, 'Cari Sorumluluk Merkezi Kodu', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (152, 2, 'Stok Sorumluluk Merkezi Kodu', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (153, 13, 'Puan Kazanma Alt Limit', '0',2);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (154, 13, 'Puan Kazanma Yüzdesi', '0',2);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (155, 3, 'Ürün Listesinde 2. Satış Fiyatı Göster', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (156, 2, 'Ayarlara Şifreli Geçiş Aktif', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (157, 2, 'Evrak No Seri Manuel Girilsin', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (158, 2, 'Stok ve Cari Sorumluluk Merkezi Kodu Manuel Girilsin', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (159, 13, 'MyShop Puan ConnStr', 'Data Source=.;Initial Catalog=DINAMIK_MY_SHOP;User ID=sa;Password=1475',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (161, 2, 'Park Yetki', '1',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (902, 2, 'UyumSoft Kullanıcı Adı', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (903, 2, 'UyumSoft Şifre', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (904, 2, 'UyumSoft Aktif', '0',3);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (905, 2, 'Nihai Tüketici Kodu', '',0);
	INSERT INTO AYARLAR(AyarID, Fk_AyarGrubu, Aciklama, Deger, VeriTipi) VALUES (906, 2, 'Firma Cari Kodu', '',0);

END

GO


IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'BANKALAR') BEGIN
	CREATE TABLE BANKALAR (
		BankaID INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
		BankaKodu nvarchar (25) NOT NULL,
		BankaAdi nvarchar (50) NOT NULL,
		SonGuncellemeTarihi DATETIME NOT NULL
	);

END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'BARKOD_TANIMLARI') BEGIN
	CREATE TABLE BARKOD_TANIMLARI (
		BarkodTanimID INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
		Fk_StokID INT NOT NULL,
		Barkod nvarchar (50) NOT NULL,
		BarkodIcerigi INT NOT NULL,
		BirimPntr INT NOT NULL,
		BarkodTipi INT NOT NULL,
		SonGuncellemeTarihi DATETIME NOT NULL
	);

	CREATE UNIQUE NONCLUSTERED INDEX IDX_BARKOD_TANIMLARI_Barkod ON dbo.BARKOD_TANIMLARI
	(Barkod ASC) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY];

END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'CARI_KARTLARI') BEGIN
	CREATE TABLE CARI_KARTLARI(
		CariID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
		CariKodu nvarchar(25) NOT NULL,
		Unvan1 nvarchar(127) NOT NULL,
		Unvan2 nvarchar(127) NOT NULL,
		CepTelefonu nvarchar(20) NOT NULL,
		SonGuncellemeTarihi datetime NOT NULL,
		SatisFiyatListeSiraNo int NOT NULL,
		FaturaAdresi nvarchar(140)  NOT NULL,
		SevkAdresi nvarchar(140)  NOT NULL,
		VergiDairesi nvarchar(50)  NOT NULL,
		VergiNo nvarchar(15)  NOT NULL,
		IskontoYuzdesi float  NOT NULL,
		VadeGunSayisi int NOT NULL,
		Fk_DovizCinsID tinyint NOT NULL,
		Fk_DovizCinsID1 tinyint NOT NULL,
		Fk_DovizCinsID2 tinyint NOT NULL,
		CariIskontoKodu nvarchar(25) NOT NULL,
		Synced bit NOT NULL,
		CariEmail nvarchar(80) NOT NULL,
		EFaturaKullanimiAktif bit NOT NULL,
		EIrsaliyeKullanimiAktif bit NOT NULL,
		CariPerakende bit NOT NULL,
		MersisNo nvarchar(50) NOT NULL,
		AdresNo int NOT NULL
	);
	CREATE UNIQUE NONCLUSTERED INDEX IDX_CARI_KARTLARI_CariKodu ON dbo.CARI_KARTLARI
	(CariKodu ASC) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY];

	CREATE NONCLUSTERED INDEX IDX_CARI_KARTLARI_Unvan1 ON dbo.CARI_KARTLARI
	(Unvan1 ASC) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY];

	CREATE NONCLUSTERED INDEX IDX_CARI_KARTLARI_VergiNo ON dbo.CARI_KARTLARI
	(VergiNo ASC) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY];

	CREATE NONCLUSTERED INDEX IDX_CARI_KARTLARI_CepTelefonu ON dbo.CARI_KARTLARI
	(CepTelefonu ASC) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY];

END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'CARI_ADRESLERI') BEGIN
	CREATE TABLE CARI_ADRESLERI(
		CariAdresId int IDENTITY(1,1) NOT NULL PRIMARY KEY,
		CariKodu nvarchar(25) NOT NULL,
		AdresNo int NOT NULL,
		Cadde nvarchar(50) NOT NULL,
		Sokak nvarchar(50) NOT NULL,
		PostaKodu nvarchar(8) NOT NULL,
		Ulke nvarchar(15) NOT NULL,
		Il nvarchar(15) NOT NULL,
		Ilce nvarchar(15) NOT NULL,
		UlkeKodu nvarchar(5) NOT NULL,
		BolgeKodu nvarchar(5) NOT NULL,
		TelefonNo1 nvarchar(10) NOT NULL,
		TelefonNo2 nvarchar(10) NOT NULL,
		FaxNo nvarchar(10) NOT NULL,
		SonGuncellemeTarihi datetime NOT NULL,
		Synced bit NOT NULL
	);
	ALTER TABLE dbo.CARI_ADRESLERI ADD  CONSTRAINT IX_CARI_ADRESLERI UNIQUE NONCLUSTERED 
	(CariKodu ASC,AdresNo ASC) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY];
END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'CARI_PERSONELLER') BEGIN
	CREATE TABLE CARI_PERSONELLER(
		CariPersonelID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
		CariPersonelKodu nvarchar(25) NOT NULL,
		CariPersonelAdi nvarchar(50) NOT NULL,
		CariPersonelSoyadi nvarchar(50) NOT NULL,
		CariPersonelTipi tinyint NOT NULL,
		CariPersonelSifresi nvarchar(100) NOT NULL,
		SonGuncellemeTarihi datetime NOT NULL,
		IsAdmin bit NOT NULL
	);
END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'DOVIZ_CINSLERI') BEGIN
	CREATE TABLE DOVIZ_CINSLERI(
		DovizCinsID int NOT NULL PRIMARY KEY,
		DovizIsmi nvarchar(50) NOT NULL,
		DovizSembolu nvarchar(3) NOT NULL,
		SonGuncellemeTarihi datetime NOT NULL
	);
	INSERT INTO DOVIZ_CINSLERI (DovizCinsID, DovizIsmi, DovizSembolu, SonGuncellemeTarihi) VALUES(0,'Türk Lirası', 'TL', '1899-12-30 00:00:00.000');
	INSERT INTO DOVIZ_CINSLERI (DovizCinsID, DovizIsmi, DovizSembolu, SonGuncellemeTarihi) VALUES(1,'Amerikan Doları', 'USD', '1899-12-30 00:00:00.000');
	INSERT INTO DOVIZ_CINSLERI (DovizCinsID, DovizIsmi, DovizSembolu, SonGuncellemeTarihi) VALUES(2,'Euro', 'EUR', '1899-12-30 00:00:00.000');
END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'DOVIZ_KURLARI') BEGIN
	CREATE TABLE DOVIZ_KURLARI(
		DovizKurID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
		Fk_DovizCinsID tinyint NOT NULL,
		AlisFiyati float NOT NULL,
		SatisFiyati float NOT NULL,
		EfektifAlisFiyati float NOT NULL,
		EfektifSatisFiyati float NOT NULL,
		DovizTarihi datetime NOT NULL,
		SonGuncellemeTarihi datetime NOT NULL
	);
	INSERT INTO DOVIZ_KURLARI (Fk_DovizCinsID, AlisFiyati, SatisFiyati, EfektifAlisFiyati, EfektifSatisFiyati, DovizTarihi, SonGuncellemeTarihi) VALUES(0,1, 1,1,1, '2000-01-01 00:00:00.000', '1899-12-30 00:00:00.000');
	INSERT INTO DOVIZ_KURLARI (Fk_DovizCinsID, AlisFiyati, SatisFiyati, EfektifAlisFiyati, EfektifSatisFiyati, DovizTarihi, SonGuncellemeTarihi) VALUES(1,1, 1,1,1, '2000-01-01 00:00:00.000', '1899-12-30 00:00:00.000');
	INSERT INTO DOVIZ_KURLARI (Fk_DovizCinsID, AlisFiyati, SatisFiyati, EfektifAlisFiyati, EfektifSatisFiyati, DovizTarihi, SonGuncellemeTarihi) VALUES(2,1, 1,1,1, '2000-01-01 00:00:00.000', '1899-12-30 00:00:00.000');

END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'FATURALAR') BEGIN
	CREATE TABLE FATURALAR(
		FaturaID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
		Fk_CariID int NULL,
		CariKodu nvarchar(25) NULL,
		PlasiyerKodu nvarchar(25) NULL,
		PosNo smallint NOT NULL,
		TarihSaat datetime NOT NULL,
		NormalIade bit NOT NULL,
		AraToplam float NOT NULL,
		Iskonto1 float NOT NULL,
		Iskonto2 float NOT NULL,
		Iskonto3 float NOT NULL,
		Iskonto4 float NOT NULL,
		Iskonto5 float NOT NULL,
		Iskonto6 float NOT NULL,
		Vergi1 float NOT NULL,
		Vergi2 float NOT NULL,
		Vergi3 float NOT NULL,
		Vergi4 float NOT NULL,
		Vergi5 float NOT NULL,
		Vergi6 float NOT NULL,
		Vergi7 float NOT NULL,
		Vergi8 float NOT NULL,
		Vergi9 float NOT NULL,
		Vergi10 float NOT NULL,
		Meblag float NOT NULL,
		Synced bit NOT NULL,
		AcikKapali tinyint NULL,
		Vade int NULL,
		Durum tinyint NOT NULL,
		Aciklama nvarchar(40) NULL,
		BelgeNo int NULL,
		TicketSynced bit NULL,
		BasimSayisi smallint NOT NULL,
		DovizCinsi tinyint NOT NULL,
		DovizKuru float NOT NULL,
		PosHandle numeric(20, 0) NOT NULL,
		FisFatura tinyint NOT NULL,
		BelgeSeri nvarchar(10) NULL,
		VergiNo nvarchar(15) NULL,
		PlasiyerKodu2 nvarchar(25) NULL,
		EvrakNoSeri nvarchar(20) NOT NULL,
		SorumlulukMerkeziKodu nvarchar(25) NOT NULL,
		UUID nvarchar(50) NOT NULL,
		FaturaNo nvarchar(50) NOT NULL,
		eSynced int NOT NULL,
		EvrakTipi tinyint NOT NULL
	);

END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'FATURA_DETAYLARI') BEGIN
	CREATE TABLE FATURA_DETAYLARI(
		FaturaDetayID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
		Fk_FaturaID int NOT NULL,
		Fk_StokID int NOT NULL,
		StokKodu nvarchar(25) NULL,
		SatirNo int NOT NULL,
		Miktar float NOT NULL,
		BirimFiyat float NOT NULL,
		Tutar float NOT NULL,
		Iskonto1 float NOT NULL,
		Iskonto2 float NOT NULL,
		Iskonto3 float NOT NULL,
		Iskonto4 float NOT NULL,
		Iskonto5 float NOT NULL,
		Iskonto6 float NOT NULL,
		Fk_VergiID int NOT NULL,
		Vergi float NOT NULL,
		Barkod nvarchar(25) NOT NULL,
		BarkodBirimi tinyint NOT NULL,
		BarkodFiyati float NOT NULL,
		BarkodKatsayisi float NOT NULL,
		BarkodMiktari float NOT NULL,
		Fk_OrjinalDovizCinsi tinyint NOT NULL,
		OrjinalDovizKuru tinyint NOT NULL,
		MobilRaporSynced bit NOT NULL
	);

END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'FATURA_SERI') BEGIN
	CREATE TABLE FATURA_SERI(
		SERI nvarchar(5) NULL,
		SIRA bigint NULL,
		YIL int NULL,
		TARIH smalldatetime NULL,
		TIP int NULL
	);

END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'ILLER') BEGIN
	CREATE TABLE ILLER(
		IlID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
		IlKodu nvarchar(3) NOT NULL,
		IlAdi nvarchar(25) NOT NULL,
		TelBolgeKodu nvarchar(5) NOT NULL,
		SonGuncellemeTarihi datetime NOT NULL
	);
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('01', 'ADANA','322','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('02', 'ADIYAMAN','416','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('03', 'AFYON','272','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('04', 'AĞRI','472','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('05', 'AMASYA','358','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('06', 'ANKARA','312','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('07', 'ANTALYA','242','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('08', 'ARTVİN','466','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('09', 'AYDIN','256','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('10', 'BALIKESİR','266','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('11', 'BİLECİK','228','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('12', 'BİNGÖL','426','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('13', 'BİTLİS','434','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('14', 'BOLU','374','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('15', 'BURDUR','248','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('16', 'BURSA','224','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('17', 'ÇANAKKALE','286','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('18', 'ÇANKIRI','376','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('19', 'ÇORUM','364','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('20', 'DENİZLİ','258','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('21', 'DİYARBAKIR','412','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('22', 'EDİRNE','284','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('23', 'ELAZIĞ','424','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('24', 'ERZİNCAN','446','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('25', 'ERZURUM','442','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('26', 'ESKİŞEHİR','222','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('27', 'GAZİANTEP','342','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('28', 'GİRESUN','454','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('29', 'GÜMÜŞHANE','456','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('30', 'HAKKARİ','438','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('31', 'HATAY','326','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('32', 'ISPARTA','246','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('33', 'MERSİN','324','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('34', 'İSTANBUL','','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('35', 'İZMİR','232','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('36', 'KARS','474','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('37', 'KASTAMONU','366','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('38', 'KAYSERİ','352','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('39', 'KIRKLARELİ','288','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('40', 'KIRŞEHİR','386','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('41', 'KOCAELİ','262','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('42', 'KONYA','332','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('43', 'KÜTAHYA','274','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('44', 'MALATYA','422','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('45', 'MANİSA','236','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('46', 'K.MARAŞ','344','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('47', 'MARDİN','482','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('48', 'MUĞLA','252','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('49', 'MUŞ','436','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('50', 'NEVŞEHİR','384','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('51', 'NİĞDE','388','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('52', 'ORDU','452','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('53', 'RİZE','464','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('54', 'SAKARYA','264','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('55', 'SAMSUN','362','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('56', 'SİİRT','484','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('57', 'SİNOP','368','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('58', 'SİVAS','346','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('59', 'TEKİRDAĞ','282','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('60', 'TOKAT','356','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('61', 'TRABZON','462','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('62', 'TUNCELİ','428','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('63', 'Ş.URFA','414','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('64', 'UŞAK','276','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('65', 'VAN','432','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('66', 'YOZGAT','354','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('67', 'ZONGULDAK','372','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('68', 'AKSARAY','382','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('69', 'BAYBURT','458','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('70', 'KARAMAN','338','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('71', 'KIRIKKALE','318','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('72', 'BATMAN','488','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('73', 'ŞIRNAK','486','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('74', 'BARTIN','378','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('75', 'ARDAHAN','478','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('76', 'IĞDIR','476','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('77', 'YALOVA','226','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('78', 'KARABÜK','370','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('79', 'KİLİS','348','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('80', 'OSMANİYE','328','1899-12-30 00:00:00.000');
	INSERT INTO ILLER( IlKodu, IlAdi, TelBolgeKodu, SonGuncellemeTarihi) VALUES('81', 'DÜZCE','380','1899-12-30 00:00:00.000');
END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'ISKONTO_TANIMLARI') BEGIN
	CREATE TABLE ISKONTO_TANIMLARI(
		IskontoTanimID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
		StokIskontoKodu nvarchar(25) NOT NULL,
		CariIskontoKodu nvarchar(25) NOT NULL,
		IskontoYuzdesi1 float NOT NULL,
		IskontoUygulama1 tinyint NOT NULL,
		IskontoYuzdesi2 float NOT NULL,
		IskontoUygulama2 tinyint NOT NULL,
		IskontoYuzdesi3 float NOT NULL,
		IskontoUygulama3 tinyint NOT NULL,
		IskontoYuzdesi4 float NOT NULL,
		IskontoUygulama4 tinyint NOT NULL,
		IskontoYuzdesi5 float NOT NULL,
		IskontoUygulama5 tinyint NOT NULL,
		IskontoYuzdesi6 float NOT NULL,
		IskontoUygulama6 tinyint NOT NULL,
		SonGuncellemeTarihi datetime NOT NULL
	);

END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'KASA_GIRIS_CIKISLAR') BEGIN
	CREATE TABLE KASA_GIRIS_CIKISLAR(
		KasaGirisCikisID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
		PlasiyerKodu nvarchar(25) NOT NULL,
		PosNo smallint NOT NULL,
		IslemTipi tinyint NOT NULL,
		TarihSaat datetime NOT NULL,
		Tutar float NOT NULL,
		Aciklama nvarchar(50) NOT NULL
	);

END

GO


IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'KATEGORILER') BEGIN
	CREATE TABLE KATEGORILER(
		KategoriID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
		KategoriKodu nvarchar(25) NOT NULL,
		KategoriAdi nvarchar(50) NOT NULL,
		SonGuncellemeTarihi datetime NOT NULL,
		IsVisible bit NOT NULL,
		VisibleIndex smallint NOT NULL
	);
	INSERT INTO KATEGORILER(KategoriKodu, KategoriAdi, SonGuncellemeTarihi, IsVisible, VisibleIndex) VALUES('PLU', 'PLU', '18991230', 1, 32767);
END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'ODEME_TANIMLARI') BEGIN
	CREATE TABLE ODEME_TANIMLARI(
		OdemeTanimNo tinyint NOT NULL,
		Aciklama nvarchar(40) NOT NULL,
		KasaHesapCinsi tinyint NOT NULL,
		KasaHesapKodu nvarchar(25) NOT NULL,
		OdemeTipi tinyint NOT NULL,
		SonGuncellemeTarihi datetime NOT NULL,
		TCMBKodu nvarchar(4) NOT NULL
	);
	INSERT INTO ODEME_TANIMLARI(OdemeTanimNo, Aciklama, KasaHesapCinsi, KasaHesapKodu, OdemeTipi, SonGuncellemeTarihi, TCMBKodu) 
	VALUES(1, 'NAKİT', 4, '100', 0,  '18991230', '');
END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'ODEMELER') BEGIN
	CREATE TABLE ODEMELER(
		OdemeID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
		Fk_FaturaID int NOT NULL,
		Fk_OdemeTanimNo tinyint NOT NULL,
		Tutar float NOT NULL,
		ParaUstu float NOT NULL,
		CekNo nvarchar(12) NULL,
		VadeTarihi datetime NULL,
		Fk_BankaID int NULL,
		BankaKodu nvarchar(25) NULL,
		Kesideci nvarchar(30) NULL
	);
END

GO

--IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'PERAKENDE_CARI_KARTLARI') BEGIN
--	CREATE TABLE PERAKENDE_CARI_KARTLARI(
--		PerakendeCariID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
--		Fk_FaturaID int NOT NULL,
--		CariAd nvarchar(127) NOT NULL,
--		CariSoyad nvarchar(127) NOT NULL,
--		VergiDaireAdi nvarchar(50) NOT NULL,
--		VergiNumarasi nvarchar(15) NOT NULL,
--		Ulke nvarchar(50) NOT NULL,
--		Il nvarchar(50) NOT NULL,
--		UlkeKodu nvarchar(5) NOT NULL,
--		BolgeKodu nvarchar(5) NOT NULL,
--		TelefonNo nvarchar(10) NOT NULL,
--		Email nvarchar(80) NOT NULL,
--		MusteriKartKodu nvarchar(24) NOT NULL
--	);
--END

--GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'REYONLAR') BEGIN
	CREATE TABLE REYONLAR(
		ReyonID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
		ReyonKodu nvarchar(25) NOT NULL,
		ReyonAdi nvarchar(40) NOT NULL,
		YuzdeIndirim float NOT NULL,
		SonGuncellemeTarihi datetime NOT NULL
	);
END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'SATIR_IPTALLERI') BEGIN
	CREATE TABLE SATIR_IPTALLERI(
		SatirIptalID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
		TarihSaat datetime NOT NULL,
		PlasiyerKodu nvarchar(25) NULL,
		Fk_StokID int NOT NULL,
		StokKodu nvarchar(25) NULL,
		Miktar float NOT NULL,
		Tutar float NOT NULL,
		Iskonto1 float NOT NULL,
		Iskonto2 float NOT NULL,
		Iskonto3 float NOT NULL,
		Iskonto4 float NOT NULL,
		Iskonto5 float NOT NULL,
		Iskonto6 float NOT NULL,
		Fk_VergiID int NOT NULL,
		Vergi float NOT NULL,
		MobilRaporSynced bit NOT NULL,
		PosNo smallint NOT NULL
	);
END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'SATIS_FIYATLARI') BEGIN
	CREATE TABLE SATIS_FIYATLARI(
		SatisFiyatID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
		Fk_StokID int NOT NULL,
		ListeSiraNo int NOT NULL,
		SatisFiyati float NOT NULL,
		DovizCinsi tinyint NOT NULL,
		SonGuncellemeTarihi datetime NOT NULL,
		IskontoYuzdesi float NULL,
		StokIskontoKodu nvarchar(25) NOT NULL,
		SatisBirimPntr tinyint NOT NULL
	);
END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'STOK_BIRIM_ESLESTIRMELERI') BEGIN
	CREATE TABLE STOK_BIRIM_ESLESTIRMELERI(
		EslestirmeID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
		Fk_StokBirimi int NOT NULL,
		KarsilikIndex tinyint NOT NULL
	);
END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'STOK_BIRIMLERI') BEGIN
	CREATE TABLE STOK_BIRIMLERI(
		StokBirimID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
		BirimAdi nvarchar(25) NOT NULL,
		BirimTipi tinyint NOT NULL,
		UCKod nvarchar(10) NOT NULL,
		SonGuncellemeTarihi datetime NOT NULL
	);
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('ADET', 0,'NIU','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('KOLİ', 0,'PK','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('PAKET', 0,'PA','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('PALET', 0,'PF','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('SANDIK', 0,'CR','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('ÇUVAL', 0,'SA','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('POŞET', 0,'BG','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('FİLE', 0,'','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('KAMYON', 0,'TC','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('KONTEYNIR', 0,'CH','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('MİLİGRAM', 1,'MGM','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('GRAM', 1,'GRM','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('KİLOGRAM', 1,'KGM','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('TON', 1,'TNE','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('LİTRE', 1,'LTR','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('MM3', 2,'MMQ','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('CM3', 2,'CMQ','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('DM3', 2,'DMQ','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('M3', 2,'MTQ','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('MM2', 3,'MMK','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('CM2', 3,'CMK','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('DM2', 3,'DMK','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('M2', 3,'MTK','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('DÖNÜM', 3,'ACR','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('MM', 4,'MMT','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('CM', 4,'CMT','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('DM', 4,'DMT','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('MT', 4,'MTR','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('KM', 4,'KMT','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('SANİYE', 5,'D62','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('DAKİKA', 5,'D61','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('SAAT', 5,'HUR','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('GÜN', 5,'DAY','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('HAFTA', 5,'WEE','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('AY', 5,'MON','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('YIL', 5,'ANN','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('TAKIM', 0,'','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('DÜZİNE', 0,'','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('SET', 0,'SET','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('KUTU', 0,'','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('RULO', 0,'','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('TÜP', 0,'','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('CİLT', 0,'','1899-12-30 00:00:00.000');
	INSERT INTO STOK_BIRIMLERI( BirimAdi, BirimTipi, UCKod, SonGuncellemeTarihi) VALUES('TABAKA', 0,'','1899-12-30 00:00:00.000');
END

GO


IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'STOK_KARTLARI') BEGIN
	CREATE TABLE STOK_KARTLARI(
		StokID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
		Fk_KategoriID int NOT NULL,
		Fk_ReyonID int NOT NULL,
		StokKodu nvarchar(25) NOT NULL,
		StokIsmi nvarchar(127) NOT NULL,
		Birim nvarchar(10) NOT NULL,
		Birim2 nvarchar(10) NOT NULL,
		Birim2Katsayi float NOT NULL,
		Birim3 nvarchar(10) NOT NULL,
		Birim3Katsayi float NOT NULL,
		Birim4 nvarchar(10) NOT NULL,
		Birim4Katsayi float NOT NULL,
		UrunResmi image NULL,
		SonGuncellemeTarihi datetime NOT NULL,
		DepodakiMiktar decimal(18, 2) NULL,
		SonStokGuncellemeTarihi smalldatetime NULL,
		IsPLU bit NULL,
		IskontoYapilamaz bit NULL,
		KayitNo int NULL,
		PerakendeVergi tinyint NULL,
		ToptanVergi tinyint NULL,
		AmbarAdresi nvarchar(25) NULL,
		SatisDursun bit NOT NULL,
		AktifPasif bit NOT NULL,
		VisibleIndex smallint NOT NULL
	);
END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'ULKELER') BEGIN
	CREATE TABLE ULKELER(
		UlkeID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
		UlkeKodu nvarchar(4) NOT NULL,
		UlkeAdi nvarchar(30) NOT NULL,
		IngilizceAdi nvarchar(30) NOT NULL,
		EBeyanNumerikKodu nvarchar(4) NOT NULL,
		TelUlkeKodu nvarchar(5) NOT NULL,
		SonGuncellemeTarihi datetime NOT NULL
	);

	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('USA', 'ABD', 'UNITED STATES', '400', '1', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('AFG', 'AFGANİSTAN', 'AFGHANISTAN', '660', '93', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('D', 'ALMANYA', 'GERMANY', '4', '49', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('AND', 'ANDORRA', 'ANDORA', '43', '376', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('ANG', 'ANGOLA', 'ANGOLA', '330', '244', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('AR', 'ARJANTİN', 'ARGENTIN', '528', '54', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('ALB', 'ARNAVUTLUK', 'ALBANIA', '70', '355', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('AUS', 'AVUSTRALYA', 'AUSTRALIA', '800', '61', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('Ö', 'AVUSTURYA', 'AUSTURIA', '38', '43', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('AZ', 'AZERBAYCAN', 'AZARBAIJAN', '78', '994', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BAH', 'BAHREYN', 'BAHRAIN', '640', '973', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BAN', 'BANGLADEŞ', 'BANGLADESH', '666', '880', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BAR', 'BARBADOS', 'BARBADOS', '469', '1246', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('B', 'BELÇİKA', 'BELGIUM', '2', '32', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BRS', 'BEYAZ RUSYA', 'BELA RUSSIA', '73', '375', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('UEA', 'BİR.ARP.EMR.', 'UNITED EMİRTES', '647', '971', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BO', 'BOLİVYA', 'BOLIVIA', '516', '591', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BH', 'BOSNA HERSEK', 'BOSNIA', '93', '387', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BR', 'BREZİLYA', 'BRASIL', '508', '55', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BG', 'BULGARİSTAN', 'BULGARIA', '68', '359', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('ALG', 'CEZAYİR', 'ALGERIA', '208', '213', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('CHC', 'ÇEÇENİSTAN', 'CHECHENISTAN', '84', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('CR', 'ÇEK.CUM.', 'CHECK REP.', '62', '420', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('CHR', 'ÇERKEZİSTAN', 'CHERKEZISTAN', '', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('RC', 'ÇİN.CUM.', 'CHINA', '720', '86', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('DAG', 'DAĞISTAN', 'DAGISTAN', '85', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('DK', 'DANİMARKA', 'DENMARK', '8', '45', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('DO', 'DOMİNİK', 'DOMINIUG', '456', '809', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('DU', 'DUBAİ', 'DUBAI', '648', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('EQ', 'EKVATOR', 'EQUATOR', '500', '593', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('RI', 'ENDONEZYA', 'INDONESIA', '700', '62', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('ARM', 'ERMENİSTAN', 'ARMANIA', '77', '374', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('EST', 'ESTONYA', 'ESTONIA', '53', '372', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('ETI', 'ETİYOPYA', 'ETIOPIA', '334', '251', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('FS', 'FAS', 'MORRACCO', '204', '212', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('PH', 'FİLİPİNLER', 'FILIPINES', '708', '63', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('FI', 'FİNLANDİYA', 'FINLAND', '32', '358', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('F', 'FRANSA', 'FRANCE', '1', '33', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('GH', 'GANA', 'GHANA', '276', '233', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('GI', 'GİNE', 'GHINE', '260', '224', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('ZA', 'GÜN.AFR.CUM.', 'REP.OF SOUTH AFR.', '390', '27', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('K', 'GÜNEY KORE', 'SOUTH KOREA', '728', '82', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('GE', 'GÜRCİSTAN', 'GEORGIA', '76', '995', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('I', 'HİNDİSTAN', 'INDIA', '664', '91', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('HR', 'HIRVATİSTAN', 'CROATIA', '92', '385', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('NL', 'HOLLANDA', 'NETHERLAND', '3', '31', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('HON', 'HONDURAS', 'HONDRAS', '424', '504', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('HK', 'HONG - KONG', 'HONG - CONG', '740', '852', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('GB', 'İNGİLTERE', 'ENGLAND', '6', '44', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('IN', 'İNGUYA', 'INGUŞIA', '', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('IRQ', 'IRAK', 'IRAQ', '612', '964', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('IR', 'İRAN', 'IRAN', '616', '98', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('IRL', 'İRLANDA', 'IRELAND', '7', '353', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('E', 'İSPANYA', 'SPAIN', '11', '34', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('IS', 'İSRAİL', 'ISRAEL', '624', '972', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('S', 'İSVEÇ', 'SWEDEN', '30', '46', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('CH', 'İSVİÇRE', 'SWITZERLAND', '36', '41', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('IT', 'İTALYA', 'ITALY', '5', '39', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('IZ', 'İZLANDA', 'ICELAND', '24', '354', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('JA', 'JAMAİKA', 'JAMAIKA', '464', '876', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('J', 'JAPONYA', 'JAPAN', '732', '81', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('KKTC', 'K.K.T.C', 'K.K.T.C', '601', '392', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('KAM', 'KAMBOÇYA', 'KAMPUCHIA', '696', '855', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('KMR', 'KAMERUN', 'KAMERUN', '302', '237', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('CAN', 'KANADA', 'CANADA', '404', '1', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('QTR', 'KATAR', 'QUATAR', '644', '974', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('KAZ', 'KAZAKİSTAN', 'KAZHAKISTAN', '79', '7', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('KE', 'KENYA', 'KENYA', '346', '254', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('CYP', 'GUNEY KIBRIS RUM YONETIMI', 'CYPRUS', '600', '357', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('KIR', 'KIRGIZİSTAN', 'KYRGYZSTAN', '83', '996', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('KRM', 'KIRIM', 'KIRIM', '', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('COL', 'KOLOMBİYA', 'COLOMBIA', '480', '57', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('KON', 'KONGO', 'CONGO', '318', '242', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('CSV', 'KOSOVA', 'COSOVA', '95', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('COS', 'KOSTARİKA', 'COSTA RICA', '436', '506', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('KW', 'KUVEYT', 'KUWAIT', '636', '965', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('RK', 'KUZEY KORE', 'NORTH KOREA', '724', '850', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('CUB', 'KÜBA', 'CUBA', '448', '53', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('LA', 'LAOS', 'LAOS', '684', '856', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('LET', 'LETONYA', 'LETONIA', '54', '371', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('LB', 'LİBERYA', 'LIBERIA', '268', '231', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('LR', 'LİBYA', 'LIBYA', '216', '218', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('LHT', 'LİHTENTAYN', 'LICHTENSTEIN', '', '423', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('LIT', 'LİTVANYA', 'LATVIA', '55', '370', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('RL', 'LÜBNAN', 'LEBANON', '604', '961', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('LUX', 'LÜKSEMBURG', 'LUXEMBOURG', '12', '352', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('HU', 'MACARİSTAN', 'HUNGARY', '64', '36', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MAD', 'MADAGASKAR', 'MADAGASCAR', '370', '261', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MAK', 'MAKEDONYA', 'MACEDONIA', '96', '389', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MAL', 'MALEZYA', 'MALAYSIA', '701', '60', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MA', 'MALİ', 'MALI', '232', '223', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MLT', 'MALTA', 'MALTA', '46', '356', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MEX', 'MEKSİKA', 'MEXICO', '412', '52', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('ET', 'MISIR', 'EGYPT', '220', '20', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MOG', 'MOĞOLİSTAN', 'MONGOLIA', '716', '976', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MOL', 'MOLDAVYA', 'MOLDAVIA', '74', '373', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MON', 'MONAKO', 'MONOCO', '493', '377', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MOR', 'MORİTANYA', 'MORITANIA', '228', '222', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MOS', 'MOZAMBİK', 'MOZAMBIQUE', '366', '258', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('NA', 'NAMİBYA', 'NAMIBIA', '389', '264', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('NEP', 'NEPAL', 'NEPAL', '672', '977', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('NIG', 'NİJERYA', 'NIGERIA', '288', '234', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('NIK', 'NİKARAGUA', 'NICARAGUA', '432', '505', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('NOR', 'NORVEÇ', 'NORWAY', '28', '47', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('OZ', 'ÖZBEKİSTAN', 'OZBEKHISTAN', '81', '998', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('PAK', 'PAKİSTAN', 'PAKISTAN', '662', '92', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('PAN', 'PANAMA', 'PANAMA', '442', '507', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('NPG', 'PAPUA Y.GİNE', 'NEW PAPUA', '801', '675', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('PAR', 'PARAGUAY', 'PARAGUAY', '520', '595', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('PE', 'PERU', 'PERU', '504', '51', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('P', 'POLONYA', 'POLAND', '60', '48', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('POR', 'PORTEKİZ', 'PORTUGAL', '10', '351', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('RW', 'RWANDA', 'RWANDA', '', '250', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('RO', 'ROMANYA', 'ROMANIA', '66', '40', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('RUS', 'RUSYA', 'RUSSIA', '75', '7', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('SM', 'SAN MARİNO', 'SAN MARINO', '674', '378', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('SEN', 'SENEGAL', 'SENEGHAL', '248', '221', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('SEL', 'SEYŞEL', 'SEYCHELLES', '355', '248', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('Sİ', 'SİNGAPUR', 'SINGAPORE', '706', '65', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('SLV', 'SLOVAKYA', 'SLOVAKIA', '63', '421', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('SLO', 'SLOVENYA', 'SLOVENIA', '91', '386', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('SOM', 'SOMALİ', 'SOMALI', '342', '252', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('SR', 'SRİLANKA', 'SRI LANKA', '669', '94', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('SU', 'SUDAN', 'SUDAN', '224', '249', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('SRM', 'SURİNAM', 'SURINAME', '492', '597', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('SYR', 'SURİYE', 'SYRIA', '608', '963', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('SA', 'SUUDI ARABİSTAN', 'SAUDI', '632', '966', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('CHL', 'ŞİLİ', 'SHILI', '512', '56', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('TA', 'TACİKİSTAN', 'TAJIKISTAN', '82', '992', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('TAN', 'TANZANYA', 'TANSANIA', '352', '255', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('TAT', 'TATARİSTAN', 'TATARISTAN', '86', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('TAI', 'TAYLAND', 'TAILAND', '680', '66', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('TAW', 'TAYVAN', 'TAIWAN', '736', '886', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('TN', 'TUNUS', 'TUNUSIA', '212', '216', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('TR', 'TÜRKİYE', 'TURKEY', '52', '90', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('TRM', 'TÜRKMENİSTAN', 'TURKMENISTAN', '80', '993', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('UG', 'UGANDA', 'UGANDA', '350', '256', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('UKR', 'UKRANYA', 'UKRAINE', '72', '380', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('OM', 'UMMAN', 'OMMAN', '649', '968', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('URG', 'URUGUAY', 'URUGUAY', '524', '598', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('JOT', 'ÜRDÜN', 'JORDAN', '628', '962', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('VAT', 'VATIKAN', 'VATICAN', '45', '379', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('VEN', 'VENEZUELLA', 'VENEZUELA', '484', '58', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('VI', 'VİETNAM', 'VIETNAM', '690', '84', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('YE', 'YEMEN', 'YEMEN', '653', '967', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('NZ', 'YENİ ZELANDA', 'NEW ZELAND', '804', '64', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('YU', 'YUGOSLAVYA', 'YUGOSLAVIA', '48', '381', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('GR', 'YUNANİSTAN', 'GREECE', '9', '30', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('ZH', 'Kongo(Eski Zaire)', 'Kongo(Eski Zaire)', '322', '243', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('ZAM', 'ZAMBİA', 'ZAMBIA', '378', '260', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('ZIM', 'ZİMBABVE', 'ZIMBABWE', '382', '263', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('CEU', 'CEUTA VE MELİLLA', '', '22', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('KAN', 'KANARYA ADALARI', ' Septe (Ceuta)', '21', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('ABD', 'ABD MINOR OUTLYING ADALARI', '', '13', '1907', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('ABDV', 'ABD VİRJİN ADALARI', '', '457', '1340', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('SAM', 'AMERİKA SAMOASI', '', '830', '684', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('AOK', 'AMERİKAN OKYANUSYASI', '', '808', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('ANGu', 'ANGUILLA', '', '446', '1264', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('ANT', 'ANTARTİKA', '', '891', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BER', 'ANTIGUA VE BERMUDA', '', '459', '1268', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('ARU', 'ARUBA', '', '474', '297', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('AV', 'AVUSTRALYA OKYANUSU', '', '802', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BAHa', 'BAHAMA', '', '453', '1242', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BSAM', 'BATI SAMAO', '', '819', '685', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BEL', 'BELİZE', '', '421', '501', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BEN', 'BENİN', '', '284', '229', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BERM', 'BERMUDA', '', '413', '1441', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BHU', 'BHUTAN', '', '675', '975', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BÜ', 'BİLİNEMEYEN ÜLKE VE TOPRAKLAR', '', '958', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BİS', 'BİSMARK ARCHİPELAGO', '', '901', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BOS', 'BOSTVANA', '', '391', '267', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BOU', 'BOUVET ADASI', '', '892', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BRU', 'BRUNEİ', '', '703', '673', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('Bur', 'Burkina Faso', '', '236', '226', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BURM', 'BURMA', '', '676', '95', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('BURD', 'BURUNDİ', '', '328', '257', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('Cap', 'Cape Verde', '', '247', '238', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('CAY', 'CAYMAN ADALARI', '', '463', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('Ceb', 'Cebeli Tarık', '', '44', '350', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('CHS', 'CHRISTMAS ADALARI', '', '834', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('CİB', 'CİBUTİ', '', '338', '253', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('Coo', 'Cook Adalar', '', '182', '682', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('Çad', 'Çad', '', '244', '235', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('DOĞ', 'DOĞU TİMOR', '', '626', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('DOM', 'DOMİNİKA', '', '460', '767', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('EKV', 'EKVATOR GİNESİ', '', '310', '240', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('EL ', 'EL SALVADOR', '', '428', '503', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('ERİ', 'ERİTRE', '', '336', '291', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('FAL', 'FALKLAND ADALARI', '', '529', '500', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('FAR', 'FAROE ADALARI', '', '25', '298', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('FİJ', 'FİJİ', '', '815', '679', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('FİL', 'FİLDİŞİ SAHİLİ', '', '272', '225', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('FRG', 'FRANSIZ GUYANASI', '', '496', '594', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('FRP', 'FRANSIZ POLİNEZYASI', '', '822', '689', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('GAB', 'GABON', '', '314', '241', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('GAM', 'GAMBİYA', '', '252', '220', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('GİN', 'GİNE-BİSSAU', '', '257', '245', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('GRE', 'GRENADA', '', '473', '1473', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('GRÖ', 'GRÖNLAND', '', '406', '299', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('GUAD', 'GUADELUP', '', '458', '590', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('GUAM', 'GUAM', '', '831', '1671', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('GUAT', 'GUATEMALA', '', '416', '502', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('GUY', 'GUYANA', '', '488', '592', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('GFR', 'GÜNEY FRANSIZ TOPRAKLARI', '', '29', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('GGE', 'GÜN.GEORGIA VE SANDWICH AD', '', '893', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('GYEM', 'GÜNEY YEMEN', '', '656', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('HAİ', 'HAİTİ', '', '452', '509', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('HEA', 'HEARD VE MC DONALD AD', '', '835', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('HOL', 'HOLLANDA ANTİLLERİ', '', '478', '599', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('İNGH', 'İNGİLİZ HİNT OKY.TOP', '', '357', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('İNGV', 'İNGİLİZ VİRJİN ADALA', '', '461', '1284', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('GAZZ', 'GAZZE', '', '625', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('KAR', 'KARADAĞ', '', '97', '382', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('KİR', 'KİRİBATİ', '', '812', '686', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('KOK', 'KOKOS ADALARI', 'Cocos (Keeling) Adalar', '833', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('KOM', 'KOMORO ADALARI', '', '375', '267', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('KUT', 'KUTUP BÖLGELERİ', '', '890', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MAR', 'KUZEY MARİANA ADALARI', '', '820', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('KYEM', 'KUZEY YEMEN', '', '652', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('LES', 'LESOTHO', '', '395', '266', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('LIE', 'LIESHTENSTEIN', '', '438', '423', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MAKA', 'MAKAO', '', '743', '853', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MALV', 'MALAVİ', '', '386', '265', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MALD', 'MALDİV ADALARI', '', '667', '960', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MARS', 'MARSHALL ADALARI', '', '824', '692', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MART', 'MARTİNİK', '', '462', '596', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MAU', 'MAURİTİUS', '', '373', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MAY', 'MAYOTTE', '', '377', '262', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MİK', 'MİKRONEZYA', '', '823', '691', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MONT', 'MONTSERRAT', '', '470', '1664', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MYA', 'MYANMAR', '', '104', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('NAU', 'NAURU', '', '803', '674', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('Nij', 'Nijer', '', '240', '227', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('NİU', 'NİUE', '', '838', '683', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('NORF', 'NORFOLK ADASI', '', '836', '672', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('ORT', 'ORTA AFRİKA CUMHURİYETİ', '', '306', '221', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('PAL', 'PALAU', '', '825', '680', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('PİT', 'PİTCAİRN', '', '813', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('REU', 'REUNİON', '', '372', '262', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('RUA', 'RUANDA', '', '324', '250', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('SAO', 'SAO TOME AND PRINCIP', '', '311', '239', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('SER', 'SERBEST BÖLGE(BA-BS için)', '', '960', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('SIE', 'SIERRA LEONE', '', '264', '232', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('SK', 'YUGOSLAVYA(SIRBİSTAN-KARADAĞ)', '', '94', '381', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('SIR', 'SIRBİSTAN', '', '98', '381', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('SOL', 'SOLOMON ADALARI', '', '806', '677', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('VİC', 'ST.VİNCENT GRENADİNLER', '', '467', '1784', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('HEL', 'ST.HELENA VE BAĞLAN', '', '329', '290', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('KİT.', 'ST.KİTTS ve NEVİS', '', '449', '1869', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('LUC.', 'ST.LUCİA', '', '465', '1758', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('PİE', 'ST.PİERRE VE MİQUEL', '', '408', '508', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('SVA', 'SVAZİLAND', '', '393', '268', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('TOG', 'TOGO', '', '280', '228', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('TOK', 'TOKELAU', '', '839', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('TON', 'TONGA', '', '817', '676', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('TRİ', 'TRİNİDAD VE TOBAGO', '', '472', '1868', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('TUR', 'TURKS VE CAİCOS ADAS', '', '454', '1649', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('TUV', 'TUVALU', '', '807', '688', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('TÜR', 'TÜRKİYE-SERBEST BÖL(BA-BSiçin)', '', '961', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('VAN', 'VANUATU', '', '816', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('WAL', 'WALLİS VE FUTUNA ADA', '', '811', '681', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('Yak', 'Yakutistan', '', '87', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('ALO', 'YENİ KALODENYA VE BA', '', '809', '687', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('ELA', 'YENİ ZELANDA OKYANUS', '', '814', '', '1899-12-30 00:00:00.000');
	INSERT INTO ULKELER( UlkeKodu, UlkeAdi, IngilizceAdi, EBeyanNumerikKodu, TelUlkeKodu, SonGuncellemeTarihi) VALUES('MLL', 'MELİLLA', ' Melilla', '23', '', '1899-12-30 00:00:00.000');
END

GO


IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'VERGILER') BEGIN
	CREATE TABLE VERGILER (
		VergiID INT NOT NULL PRIMARY KEY,
		VergiYuzdesi tinyint NOT NULL,
		VergiIsmi nvarchar (50) NOT NULL
	);
	
	INSERT INTO VERGILER(VergiID, VergiYuzdesi, VergiIsmi) VALUES(1, 0, 'YOK');
	INSERT INTO VERGILER(VergiID, VergiYuzdesi, VergiIsmi) VALUES(2, 1, 'K.D.V. (%) 1');
	INSERT INTO VERGILER(VergiID, VergiYuzdesi, VergiIsmi) VALUES(3, 10, 'K.D.V. (%) 10');
	INSERT INTO VERGILER(VergiID, VergiYuzdesi, VergiIsmi) VALUES(4, 20, 'K.D.V. (%) 20');
	INSERT INTO VERGILER(VergiID, VergiYuzdesi, VergiIsmi) VALUES(5, 0, 'ÖZEL MATRAH');
	INSERT INTO VERGILER(VergiID, VergiYuzdesi, VergiIsmi) VALUES(6, 0, '');
	INSERT INTO VERGILER(VergiID, VergiYuzdesi, VergiIsmi) VALUES(7, 0, '');
	INSERT INTO VERGILER(VergiID, VergiYuzdesi, VergiIsmi) VALUES(8, 0, '');
	INSERT INTO VERGILER(VergiID, VergiYuzdesi, VergiIsmi) VALUES(9, 0, '');
	INSERT INTO VERGILER(VergiID, VergiYuzdesi, VergiIsmi) VALUES(10, 0, '');

END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'VERGI_DAIRELERI') BEGIN
	CREATE TABLE VERGI_DAIRELERI (
		VergiDaireID INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
		OrjinalKodu nvarchar(10) NOT NULL,
		VergiDaireAdi nvarchar(50) NOT NULL,
		Il nvarchar(50) NOT NULL,
		Ilce nvarchar(50) NOT NULL,
		SonGuncellemeTarihi datetime NOT NULL
	);
END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'TEMP_TAHSILAT_DETAYLARI') BEGIN
	CREATE TABLE TEMP_TAHSILAT_DETAYLARI(
		HareketCinsi nchar(50) NOT NULL,
		VadeTarihi datetime NOT NULL,
		VadeGunSayisi int NOT NULL,
		HesapKodu nvarchar(25) NOT NULL,
		HesapAdi nchar(50) NOT NULL,
		CariKodu nvarchar(25) NOT NULL,
		CariUnvan nvarchar(50) NOT NULL,
		Meblag int NOT NULL,
		Aciklama nvarchar(100) NOT NULL,
		DovizCinsID tinyint NOT NULL
	);
END

GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE type='U' and name = 'YAZDIRMA_PARAMETRELERI') BEGIN
	CREATE TABLE YAZDIRMA_PARAMETRELERI(
		YazdirmaParametreID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
		Aciklama nvarchar(50) NOT NULL,
		TaslakDosyaYolu nvarchar(254) NOT NULL,
		YaziciYolu nvarchar(254) NOT NULL,
		Durum bit NOT NULL,
		IslemTipi tinyint NOT NULL
	);
END

GO


IF  EXISTS (SELECT * FROM sys.objects WHERE name=N'CariSatisFiyatDovizCinsiAl' AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION dbo.CariSatisFiyatDovizCinsiAl
GO

CREATE FUNCTION [dbo].[CariSatisFiyatDovizCinsiAl](@StokID INT,@CariID INT)
RETURNS TINYINT
AS
BEGIN
	DECLARE @ListeSiraNo INT;
	SELECT @ListeSiraNo=SatisFiyatListeSiraNo 
	FROM CARI_KARTLARI 
	WHERE CariID=@CariID;

	RETURN dbo.SatisFiyatiDovizCinsiAl(@StokID,ISNULL(@ListeSiraNo,1));

END

GO



IF  EXISTS (SELECT * FROM sys.objects WHERE name=N'CariSatisFiyatiAl' AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION dbo.CariSatisFiyatiAl
GO

CREATE FUNCTION dbo.CariSatisFiyatiAl(@StokID INT,@CariID INT,@BirimPntr TINYINT)
RETURNS FLOAT
AS
BEGIN
	DECLARE @ListeSiraNo INT;
	SELECT @ListeSiraNo=(CASE WHEN 1<>1 AND SatisFiyatListeSiraNo=1 THEN 1 
							  ELSE SatisFiyatListeSiraNo END)
	FROM CARI_KARTLARI 
	WHERE CariID=@CariID;

	RETURN dbo.SatisFiyatiAl(@StokID,ISNULL(@ListeSiraNo,1),@BirimPntr);

END

GO

IF  EXISTS (SELECT * FROM sys.objects WHERE name=N'DovizIsmiAl' AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION dbo.DovizIsmiAl
GO

CREATE FUNCTION dbo.DovizIsmiAl(@DovizCinsID TINYINT)
RETURNS NVARCHAR(50)
AS
BEGIN
	DECLARE @ReturnValue NVARCHAR(50);

	SELECT @ReturnValue=DovizIsmi
	FROM DOVIZ_CINSLERI 
	WHERE DovizCinsID=@DovizCinsID ;

	RETURN ISNULL(@ReturnValue,'');
END

GO

IF  EXISTS (SELECT * FROM sys.objects WHERE name=N'DovizKuruAl' AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION dbo.DovizKuruAl
GO

CREATE FUNCTION dbo.DovizKuruAl(@DovizCinsID TINYINT,@Tarih DATETIME,@HesaplamaSekli TINYINT)
RETURNS FLOAT
AS
BEGIN
	DECLARE @Kur FLOAT;

	SELECT TOP 1 @Kur=(CASE WHEN @HesaplamaSekli=0 THEN AlisFiyati 
							  WHEN @HesaplamaSekli=1 THEN SatisFiyati 
							  WHEN @HesaplamaSekli=2 THEN EfektifAlisFiyati 
							  WHEN @HesaplamaSekli=3 THEN EfektifSatisFiyati 
							  ELSE 1 END)
	FROM DOVIZ_KURLARI 
	WHERE Fk_DovizCinsID=@DovizCinsID AND DovizTarihi<=@Tarih 
	ORDER BY DovizTarihi DESC;

	IF @Kur IS NULL AND @DovizCinsID=0
		SET @Kur=1;

	RETURN ISNULL(@Kur,0);

END

GO

IF  EXISTS (SELECT * FROM sys.objects WHERE name=N'DovizSemboluAl' AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION dbo.DovizSemboluAl
GO

CREATE FUNCTION dbo.DovizSemboluAl(@DovizCinsID TINYINT)
RETURNS NVARCHAR(3)
AS
BEGIN
	DECLARE @ReturnValue NVARCHAR(3);
	
	SELECT @ReturnValue=DovizSembolu
	FROM DOVIZ_CINSLERI 
	WHERE DovizCinsID=@DovizCinsID ;

	RETURN ISNULL(@ReturnValue,'');
END
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE name=N'DovizSemboluKisaGetir' AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION dbo.DovizSemboluKisaGetir
GO

CREATE FUNCTION dbo.DovizSemboluKisaGetir(@DovizKodu NVARCHAR(3))
RETURNS NVARCHAR(3)
AS
BEGIN
	DECLARE @ReturnValue NVARCHAR(3)

	IF @DovizKodu='TL'
		SET @ReturnValue='TL';
	ELSE IF @DovizKodu='USD'
		SET @ReturnValue='$';
	ELSE IF @DovizKodu='EUR'
		SET @ReturnValue='€';
	ELSE IF @DovizKodu='GBP'
		SET @ReturnValue='£';
	ELSE
		SET @ReturnValue=@DovizKodu

	RETURN @ReturnValue;
END
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE name=N'FaturaOdemeTipleri' AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION dbo.FaturaOdemeTipleri
GO

CREATE FUNCTION dbo.FaturaOdemeTipleri(@FaturaID INT)
RETURNS NVARCHAR(50)
AS
BEGIN
	DECLARE @ReturnValue NVARCHAR(50);

	SELECT TOP 1 @ReturnValue=OT.Aciklama FROM ODEMELER O INNER JOIN
	ODEME_TANIMLARI OT ON O.Fk_OdemeTanimNo=OT.OdemeTanimNo
	WHERE O.Fk_FaturaID=@FaturaID;

	RETURN ISNULL(@ReturnValue,'');
END
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE name=N'IskontoYuzdesiAl' AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION dbo.IskontoYuzdesiAl
GO

CREATE FUNCTION dbo.IskontoYuzdesiAl(@StokID INT,@ListeSiraNo INT)
RETURNS FLOAT
AS
BEGIN
	DECLARE @IskontoYuzdesi FLOAT;

	SELECT @IskontoYuzdesi=IskontoYuzdesi 
	FROM SATIS_FIYATLARI 
	WHERE Fk_StokID=@StokID AND ListeSiraNo=@ListeSiraNo;

	IF @IskontoYuzdesi IS NULL AND @ListeSiraNo<>1 
		SELECT @IskontoYuzdesi=IskontoYuzdesi 
		FROM SATIS_FIYATLARI 
		WHERE Fk_StokID=@StokID AND ListeSiraNo=1;

	RETURN ISNULL(@IskontoYuzdesi,0);

END
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE name=N'IskontoYuzdesiAl2' AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION dbo.IskontoYuzdesiAl2
GO


CREATE FUNCTION dbo.IskontoYuzdesiAl2(@StokID INT,@CariID INT)
RETURNS FLOAT
AS
BEGIN
	DECLARE @ListeSiraNo INT;
	SELECT @ListeSiraNo=(CASE WHEN 1<>1 AND SatisFiyatListeSiraNo=1 THEN 1 
							  ELSE SatisFiyatListeSiraNo END)
	FROM CARI_KARTLARI 
	WHERE CariID=@CariID;

	RETURN dbo.IskontoYuzdesiAl(@StokID,ISNULL(@ListeSiraNo,1));

END

GO

IF  EXISTS (SELECT * FROM sys.objects WHERE name=N'KurHesaplamaSekli' AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION dbo.KurHesaplamaSekli
GO

CREATE FUNCTION dbo.KurHesaplamaSekli()
RETURNS TINYINT
AS
BEGIN
	DECLARE @ReturnValue TINYINT;
	SELECT @ReturnValue=CONVERT(TINYINT,Deger) 
	FROM AYARLAR 
	WHERE AyarID=39;

	RETURN @ReturnValue
END

GO

IF  EXISTS (SELECT * FROM sys.objects WHERE name=N'MikroKatsayiDuzelt' AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION dbo.MikroKatsayiDuzelt
GO

CREATE FUNCTION dbo.MikroKatsayiDuzelt(@Katsayi FLOAT)
RETURNS FLOAT
AS
BEGIN
	DECLARE @ReturnValue FLOAT;

	IF @Katsayi>0
		SET @ReturnValue=1/@Katsayi
	ELSE
		SET @ReturnValue=-1*@Katsayi

	RETURN ISNULL(@ReturnValue,0);

END
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE name=N'SatisFiyatiAl' AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION dbo.SatisFiyatiAl
GO

CREATE FUNCTION dbo.SatisFiyatiAl(@StokID INT,@ListeSiraNo INT,@BirimPntr TINYINT)
RETURNS FLOAT
AS
BEGIN
	DECLARE @SatisFiyati FLOAT;

	SELECT TOP 1 @SatisFiyati=SatisFiyati 
	FROM SATIS_FIYATLARI 
	WHERE Fk_StokID=@StokID AND 
		  ListeSiraNo=@ListeSiraNo AND 
		  (SatisBirimPntr=@BirimPntr OR 
		   (@BirimPntr=1 AND SatisBirimPntr=@BirimPntr) -- Müşteri hatalı şekilde 0. birim girmişse
		  ) 
	ORDER BY SatisBirimPntr DESC;

	-- Birime ait fiyat bulunamazsa 1. birim ile çarpılan fiyatı
	IF @SatisFiyati IS NULL AND @BirimPntr>1
	BEGIN
		SELECT TOP 1 @SatisFiyati=SatisFiyati
							*
							dbo.MikroKatsayiDuzelt(CASE WHEN @BirimPntr=2 THEN Birim2Katsayi 
														WHEN @BirimPntr=3 THEN Birim3Katsayi 
														WHEN @BirimPntr=4 THEN Birim4Katsayi 
														ELSE 1 END)
		FROM SATIS_FIYATLARI INNER JOIN STOK_KARTLARI ON Fk_StokID=StokID 
		WHERE Fk_StokID=@StokID AND 
			  ListeSiraNo=@ListeSiraNo AND 
			  (SatisBirimPntr=1 OR SatisBirimPntr=0) 
		ORDER BY SatisBirimPntr DESC;
	END

	-- Satış fiyatı bulunamazsa 1. satış fiyatı
	IF @SatisFiyati IS NULL AND @ListeSiraNo<>1 
		SET @SatisFiyati=dbo.SatisFiyatiAl(@StokID,1,@BirimPntr) 

	RETURN ISNULL(@SatisFiyati,0);

END
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE name=N'SatisFiyatiDovizCinsiAl' AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION dbo.SatisFiyatiDovizCinsiAl
GO

CREATE FUNCTION dbo.SatisFiyatiDovizCinsiAl(@StokID INT,@ListeSiraNo INT)
RETURNS TINYINT
AS
BEGIN
	DECLARE @DovizCinsi TINYINT;

	SELECT @DovizCinsi=DovizCinsi 
	FROM SATIS_FIYATLARI 
	WHERE Fk_StokID=@StokID AND ListeSiraNo=@ListeSiraNo;

	-- Döviz cinsi bulunamazsa 1. satış fiyatı
	IF @DovizCinsi IS NULL AND @ListeSiraNo<>1 
		SELECT @DovizCinsi=DovizCinsi 
		FROM SATIS_FIYATLARI 
		WHERE Fk_StokID=@StokID AND ListeSiraNo=1;

	RETURN ISNULL(@DovizCinsi,0);

END

GO


IF  EXISTS (SELECT * FROM sys.objects WHERE name=N'VergiYuzdesiAl' AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION dbo.VergiYuzdesiAl
GO

CREATE FUNCTION dbo.VergiYuzdesiAl(@VergiID TINYINT)
RETURNS TINYINT
AS
BEGIN
	DECLARE @VergiYuzdesi TINYINT;

	SELECT @VergiYuzdesi=VergiYuzdesi 
	FROM VERGILER 
	WHERE VergiID=@VergiID;

	RETURN ISNULL(@VergiYuzdesi,0);

END
GO


IF EXISTS(SELECT * FROM sys.objects WHERE type='V' and name='IADE_IPTAL_VIEW')
	DROP VIEW [dbo].[IADE_IPTAL_VIEW];

GO

CREATE VIEW [dbo].[IADE_IPTAL_VIEW]
AS 
SELECT [FaturaID]
      ,F.[CariKodu]
      ,ISNULL([Unvan1],'') Unvan1
      ,[PlasiyerKodu]
      ,ISNULL((CariPersonelAdi +' - '+ CariPersonelSoyadi ),'') AS CariPersonel
      ,[PosNo]
      ,[TarihSaat]
      ,[NormalIade]
      ,[AraToplam]
      ,F.[Iskonto1] BelgeIskonto1
      ,F.[Iskonto2] BelgeIskonto2
      ,F.[Iskonto3] BelgeIskonto3
      ,F.[Iskonto4] BelgeIskonto4
      ,F.[Iskonto5] BelgeIskonto5
      ,F.[Iskonto6] BelgeIskonto6
      ,[Meblag]
      ,F.[Synced]
      ,[AcikKapali]
      ,[Vade]
      ,[Durum]
      ,[Aciklama]
      ,[BelgeNo]
      ,[TicketSynced]
      ,[BasimSayisi]
      ,[DovizCinsi]
      ,[DovizKuru]
      ,[PosHandle]
      ,[FisFatura]
      ,ISNULL([BelgeSeri],'') [BelgeSeri]
      ,ISNULL(F.[VergiNo],'') [VergiNo]
	   ,[FaturaDetayID]
      ,[Fk_FaturaID]
      ,FD.[StokKodu]
      ,[StokIsmi]
      ,[SatirNo]
      ,[Miktar]
      ,[BirimFiyat]
      ,[Tutar]
      ,FD.[Iskonto1] SatirIskontosu1
      ,FD.[Iskonto2] SatirIskontosu2
      ,FD.[Iskonto3] SatirIskontosu3
      ,FD.[Iskonto4] SatirIskontosu4
      ,FD.[Iskonto5] SatirIskontosu5
      ,FD.[Iskonto6] SatirIskontosu6
      ,[VergiYuzdesi]
      ,[Vergi]
      ,[Barkod]
      ,[BarkodBirimi]
      ,[BarkodFiyati]
      ,[BarkodKatsayisi]
      ,[BarkodMiktari]
      ,DovizSembolu
      ,[OrjinalDovizKuru]
FROM FATURALAR F INNER JOIN FATURA_DETAYLARI FD ON FD.Fk_FaturaID=F.FaturaID 
INNER JOIN STOK_KARTLARI ON Fk_StokID=StokID
LEFT JOIN CARI_KARTLARI ON Fk_CariID=CariID
INNER JOIN VERGILER ON Fk_VergiID=VergiID
INNER JOIN DOVIZ_CINSLERI ON Fk_OrjinalDovizCinsi=DovizCinsID
LEFT JOIN CARI_PERSONELLER ON PlasiyerKodu=CariPersonelKodu
WHERE (F.Durum=0 OR F.NormalIade=1)  AND MobilRaporSynced=0
UNION ALL 
SELECT 0 [FaturaID]
      ,'' [CariKodu]
      ,'' Unvan1
      ,[PlasiyerKodu]
      ,ISNULL((CariPersonelAdi +' - '+ CariPersonelSoyadi ),'') AS CariPersonel
      ,[PosNo]
      ,[TarihSaat]
      ,0 [NormalIade]
      ,0 [AraToplam]
      ,0 BelgeIskonto1
      ,0 BelgeIskonto2
      ,0 BelgeIskonto3
      ,0 BelgeIskonto4
      ,0 BelgeIskonto5
      ,0 BelgeIskonto6
      ,0[Meblag]
      ,0 [Synced]
      ,0 [AcikKapali]
      ,0 [Vade]
      ,0 [Durum]
      ,'' [Aciklama]
      ,0 [BelgeNo]
      ,0 [TicketSynced]
      ,0 [BasimSayisi]
      ,0 [DovizCinsi]
      ,0 [DovizKuru]
      ,0 [PosHandle]
      ,0 [FisFatura]
      ,'' [BelgeSeri]
      ,'' [VergiNo]
	  ,SatirIptalID AS [FaturaDetayID]
      ,0 [Fk_FaturaID]
      ,SI.[StokKodu]
      ,[StokIsmi]
      ,0 [SatirNo]
      ,[Miktar]
      ,0 [BirimFiyat]
      ,[Tutar]
      ,[Iskonto1] SatirIskontosu1
      ,[Iskonto2] SatirIskontosu2
      ,[Iskonto3] SatirIskontosu3
      ,[Iskonto4] SatirIskontosu4
      ,[Iskonto5] SatirIskontosu5
      ,[Iskonto6] SatirIskontosu6
      ,[VergiYuzdesi]
      ,[Vergi]
      ,'' [Barkod]
      ,0 [BarkodBirimi]
      ,0 [BarkodFiyati]
      ,0 [BarkodKatsayisi]
      ,0 [BarkodMiktari]
      ,'' DovizSembolu
      ,0 [OrjinalDovizKuru]
FROM SATIR_IPTALLERI SI
INNER JOIN STOK_KARTLARI ON Fk_StokID=StokID
INNER JOIN VERGILER ON Fk_VergiID=VergiID
LEFT JOIN CARI_PERSONELLER ON PlasiyerKodu=CariPersonelKodu
WHERE MobilRaporSynced=0
GO
