-- Bu kod çalıştırılmadan önce D:\SQL_DATA klasörü oluşturulmalıdır.

USE [master]
GO

-- BONUS_HELPER veritabanını oluştur (eğer yoksa)
IF NOT EXISTS (SELECT name FROM sys.databases WHERE name = N'BONUS_HELPER')
BEGIN
    CREATE DATABASE [BONUS_HELPER] ON PRIMARY 
    ( NAME = N'BONUS_HELPER', FILENAME = N'D:\SQL_DATA\BONUS_HELPER.mdf' , SIZE = 5120KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB )
    LOG ON 
    ( NAME = N'BONUS_HELPER_log', FILENAME = N'D:\SQL_DATA\BONUS_HELPER_log.ldf' , SIZE = 1024KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)
END
GO

USE [BONUS_HELPER]
GO

-- KULLANICILAR tablosu
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[KULLANICILAR]') AND type in (N'U'))
BEGIN
    CREATE TABLE [dbo].[KULLANICILAR](
        [KullaniciID] [int] IDENTITY(1,1) NOT NULL,
        [KullaniciAdi] [nvarchar](50) NOT NULL,
        [Sifre] [nvarchar](255) NOT NULL,
        [AdSoyad] [nvarchar](100) NULL,
        [Email] [nvarchar](100) NULL,
        [Telefon] [nvarchar](20) NULL,
        [AdminKullanici] [bit] NOT NULL,
        [Durum] [tinyint] NOT NULL,
        [OlusturmaTarihi] [datetime] NOT NULL,
        [GuncellemeTarihi] [datetime] NOT NULL,
     CONSTRAINT [PK_KULLANICILAR] PRIMARY KEY CLUSTERED ([KullaniciID] ASC),
     CONSTRAINT [UK_KULLANICILAR_KullaniciAdi] UNIQUE ([KullaniciAdi])
    )
END
GO

-- Default değerler
ALTER TABLE [dbo].[KULLANICILAR] ADD CONSTRAINT [DF_KULLANICILAR_OlusturmaTarihi] DEFAULT (GETDATE()) FOR [OlusturmaTarihi]
GO
ALTER TABLE [dbo].[KULLANICILAR] ADD CONSTRAINT [DF_KULLANICILAR_GuncellemeTarihi] DEFAULT (GETDATE()) FOR [GuncellemeTarihi]
GO
ALTER TABLE [dbo].[KULLANICILAR] ADD CONSTRAINT [DF_KULLANICILAR_Durum] DEFAULT ((1)) FOR [Durum]
GO
ALTER TABLE [dbo].[KULLANICILAR] ADD CONSTRAINT [DF_KULLANICILAR_AdminKullanici] DEFAULT ((0)) FOR [AdminKullanici]
GO

-- Varsayılan admin kullanıcı (Şifre: "1" - Plain text)
IF NOT EXISTS (SELECT * FROM [dbo].[KULLANICILAR] WHERE KullaniciAdi = 'bonusadmin')
BEGIN
    INSERT INTO [dbo].[KULLANICILAR] (KullaniciAdi, Sifre, AdSoyad, AdminKullanici, Durum)
    VALUES ('bonusadmin', '1', 'Sistem Yöneticisi', 1, 1)
END
GO

-- GIRIS_LOGLARI tablosu
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GIRIS_LOGLARI]') AND type in (N'U'))
BEGIN
    CREATE TABLE [dbo].[GIRIS_LOGLARI](
        [LogID] [int] IDENTITY(1,1) NOT NULL,
        [Fk_KullaniciID] [int] NOT NULL,
        [GirisTarihi] [datetime] NOT NULL,
        [IpAdresi] [nvarchar](50) NULL,
        [MachineName] [nvarchar](100) NULL,
     CONSTRAINT [PK_GIRIS_LOGLARI] PRIMARY KEY CLUSTERED ([LogID] ASC)
    )
END
GO

-- Default değer
ALTER TABLE [dbo].[GIRIS_LOGLARI] ADD CONSTRAINT [DF_GIRIS_LOGLARI_GirisTarihi] DEFAULT (GETDATE()) FOR [GirisTarihi]
GO

-- Foreign key
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_GIRIS_LOGLARI_KULLANICILAR')
BEGIN
    ALTER TABLE [dbo].[GIRIS_LOGLARI] WITH NOCHECK 
    ADD CONSTRAINT [FK_GIRIS_LOGLARI_KULLANICILAR] FOREIGN KEY([Fk_KullaniciID])
    REFERENCES [dbo].[KULLANICILAR] ([KullaniciID])
    ON UPDATE CASCADE
    ON DELETE CASCADE
END
GO

-- AYARLAR tablosu (Key/Value yapısı)
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AYARLAR]') AND type in (N'U'))
BEGIN
    CREATE TABLE [dbo].[AYARLAR](
        [AyarID] [int] IDENTITY(1,1) NOT NULL,
        [AyarKey] [nvarchar](100) NOT NULL,
        [AyarValue] [nvarchar](500) NULL,
        [Aciklama] [nvarchar](250) NULL,
        [Kategori] [nvarchar](50) NULL,
        [Fk_Olusturan] [int] NOT NULL,
        [OlusturmaTarihi] [datetime] NOT NULL,
        [Fk_Guncelleyen] [int] NOT NULL,
        [GuncellemeTarihi] [datetime] NOT NULL,
        [Aktif] [bit] NOT NULL,
     CONSTRAINT [PK_AYARLAR] PRIMARY KEY CLUSTERED ([AyarID] ASC),
     CONSTRAINT [UK_AYARLAR_Key] UNIQUE ([AyarKey])
    )
END
GO

-- Default değerler
ALTER TABLE [dbo].[AYARLAR] ADD CONSTRAINT [DF_AYARLAR_OlusturmaTarihi] DEFAULT (GETDATE()) FOR [OlusturmaTarihi]
GO
ALTER TABLE [dbo].[AYARLAR] ADD CONSTRAINT [DF_AYARLAR_GuncellemeTarihi] DEFAULT (GETDATE()) FOR [GuncellemeTarihi]
GO
ALTER TABLE [dbo].[AYARLAR] ADD CONSTRAINT [DF_AYARLAR_Aktif] DEFAULT ((1)) FOR [Aktif]
GO

-- SMS ve Email ayarları için seed data
IF NOT EXISTS (SELECT * FROM [dbo].[AYARLAR] WHERE AyarKey = 'SMS_AKTIF')
BEGIN
    INSERT INTO [dbo].[AYARLAR] (AyarKey, AyarValue, Aciklama, Kategori, Fk_Olusturan, Fk_Guncelleyen, Aktif)
    VALUES 
    -- SMS Ayarları
    ('SMS_AKTIF', 'False', 'SMS gönderim sistemi aktif/pasif', 'SMS', 1, 1, 1),
    ('SMS_API_URL', '', 'SMS servisi API URL', 'SMS', 1, 1, 1),
    ('SMS_API_KEY', '', 'SMS servisi API anahtarı', 'SMS', 1, 1, 1),
    ('SMS_SENDER', '', 'SMS gönderen başlık', 'SMS', 1, 1, 1),
    ('SMS_USERNAME', '', 'SMS servisi kullanıcı adı', 'SMS', 1, 1, 1),
    ('SMS_PASSWORD', '', 'SMS servisi şifre', 'SMS', 1, 1, 1),
    
    -- Email Ayarları
    ('EMAIL_AKTIF', 'False', 'Email gönderim sistemi aktif/pasif', 'EMAIL', 1, 1, 1),
    ('EMAIL_SMTP_HOST', '', 'SMTP sunucu adresi', 'EMAIL', 1, 1, 1),
    ('EMAIL_SMTP_PORT', '587', 'SMTP port numarası', 'EMAIL', 1, 1, 1),
    ('EMAIL_USERNAME', '', 'Email kullanıcı adı', 'EMAIL', 1, 1, 1),
    ('EMAIL_PASSWORD', '', 'Email şifre', 'EMAIL', 1, 1, 1),
    ('EMAIL_FROM', '', 'Gönderen email adresi', 'EMAIL', 1, 1, 1),
    ('EMAIL_FROM_NAME', '', 'Gönderen adı', 'EMAIL', 1, 1, 1),
    ('EMAIL_USE_SSL', 'True', 'SSL kullan', 'EMAIL', 1, 1, 1),
    
    -- Genel Ayarlar
    ('APP_TITLE', 'BonusHelper - IBM Genius3 Puan Yönetimi', 'Uygulama başlığı', 'GENEL', 1, 1, 1),
    ('APP_VERSION', '1.0.0', 'Uygulama versiyonu', 'GENEL', 1, 1, 1),
    ('LOG_LEVEL', 'INFO', 'Log seviyesi (DEBUG, INFO, WARNING, ERROR)', 'GENEL', 1, 1, 1)
END
GO

-- Foreign key ekle (KULLANICILAR tablosuna)
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[KULLANICILAR]') AND type in (N'U'))
BEGIN
    IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_AYARLAR_KULLANICILAR_Olusturan')
    BEGIN
        ALTER TABLE [dbo].[AYARLAR] WITH NOCHECK 
        ADD CONSTRAINT [FK_AYARLAR_KULLANICILAR_Olusturan] FOREIGN KEY([Fk_Olusturan])
        REFERENCES [dbo].[KULLANICILAR] ([KullaniciID])
        ON UPDATE NO ACTION
        ON DELETE NO ACTION
    END
    
    IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_AYARLAR_KULLANICILAR_Guncelleyen')
    BEGIN
        ALTER TABLE [dbo].[AYARLAR] WITH NOCHECK 
        ADD CONSTRAINT [FK_AYARLAR_KULLANICILAR_Guncelleyen] FOREIGN KEY([Fk_Guncelleyen])
        REFERENCES [dbo].[KULLANICILAR] ([KullaniciID])
        ON UPDATE NO ACTION
        ON DELETE NO ACTION
    END
END
GO

PRINT 'AYARLAR tablosu başarıyla oluşturuldu.'
GO
